/*
 * Decompiled with CFR 0.152.
 */
package aima.core.agent.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ObjectWithDynamicAttributes {
    private Map<Object, Object> attributes = new LinkedHashMap<Object, Object>();

    public String describeType() {
        return this.getClass().getSimpleName();
    }

    public String describeAttributes() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object key : this.attributes.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(key);
            sb.append("==");
            sb.append(this.attributes.get(key));
        }
        sb.append("]");
        return sb.toString();
    }

    public Set<Object> getKeySet() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public ObjectWithDynamicAttributes copy() {
        ObjectWithDynamicAttributes copy = null;
        try {
            copy = (ObjectWithDynamicAttributes)this.getClass().newInstance();
            copy.attributes.putAll(this.attributes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return super.equals(o);
        }
        return this.attributes.equals(((ObjectWithDynamicAttributes)o).attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.describeType());
        sb.append(this.describeAttributes());
        return sb.toString();
    }
}

