/*
 * Decompiled with CFR 0.152.
 */
package aima.core.agent.impl;

import aima.core.agent.Action;
import aima.core.agent.Agent;
import aima.core.agent.Environment;
import aima.core.agent.EnvironmentObject;
import aima.core.agent.EnvironmentView;
import aima.core.agent.EnvironmentViewNotifier;
import aima.core.agent.Percept;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEnvironment
implements Environment,
EnvironmentViewNotifier {
    protected Set<EnvironmentObject> envObjects = new LinkedHashSet<EnvironmentObject>();
    protected Set<Agent> agents = new LinkedHashSet<Agent>();
    protected Set<EnvironmentView> views = new LinkedHashSet<EnvironmentView>();
    protected Map<Agent, Double> performanceMeasures = new LinkedHashMap<Agent, Double>();

    public abstract void executeAction(Agent var1, Action var2);

    public abstract Percept getPerceptSeenBy(Agent var1);

    public void createExogenousChange() {
    }

    @Override
    public List<Agent> getAgents() {
        return new ArrayList<Agent>(this.agents);
    }

    @Override
    public void addAgent(Agent a) {
        this.addEnvironmentObject(a);
    }

    @Override
    public void removeAgent(Agent a) {
        this.removeEnvironmentObject(a);
    }

    @Override
    public List<EnvironmentObject> getEnvironmentObjects() {
        return new ArrayList<EnvironmentObject>(this.envObjects);
    }

    @Override
    public void addEnvironmentObject(EnvironmentObject eo) {
        Agent a;
        this.envObjects.add(eo);
        if (eo instanceof Agent && !this.agents.contains(a = (Agent)eo)) {
            this.agents.add(a);
            this.notifyEnvironmentViews(a);
        }
    }

    @Override
    public void removeEnvironmentObject(EnvironmentObject eo) {
        this.envObjects.remove(eo);
        this.agents.remove(eo);
    }

    @Override
    public void step() {
        for (Agent agent : this.agents) {
            if (!agent.isAlive()) continue;
            Action anAction = agent.execute(this.getPerceptSeenBy(agent));
            this.executeAction(agent, anAction);
            this.notifyEnvironmentViews(agent, anAction);
        }
        this.createExogenousChange();
    }

    @Override
    public void step(int n) {
        for (int i = 0; i < n; ++i) {
            this.step();
        }
    }

    @Override
    public void stepUntilDone() {
        while (!this.isDone()) {
            this.step();
        }
    }

    @Override
    public boolean isDone() {
        for (Agent agent : this.agents) {
            if (!agent.isAlive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getPerformanceMeasure(Agent forAgent) {
        Double pm = this.performanceMeasures.get(forAgent);
        if (null == pm) {
            pm = new Double(0.0);
            this.performanceMeasures.put(forAgent, pm);
        }
        return pm;
    }

    @Override
    public void addEnvironmentView(EnvironmentView ev) {
        this.views.add(ev);
    }

    @Override
    public void removeEnvironmentView(EnvironmentView ev) {
        this.views.remove(ev);
    }

    @Override
    public void notifyViews(String msg) {
        for (EnvironmentView ev : this.views) {
            ev.notify(msg);
        }
    }

    protected void updatePerformanceMeasure(Agent forAgent, double addTo) {
        this.performanceMeasures.put(forAgent, this.getPerformanceMeasure(forAgent) + addTo);
    }

    protected void notifyEnvironmentViews(Agent agent) {
        for (EnvironmentView view : this.views) {
            view.agentAdded(agent, this);
        }
    }

    protected void notifyEnvironmentViews(Agent agent, Action action) {
        for (EnvironmentView view : this.views) {
            view.agentActed(agent, action, this);
        }
    }
}

