/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Util {
    public static final String NO = "No";
    public static final String YES = "Yes";
    private static Random r = new Random();

    public static <T> T first(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            arrayList.add(t);
        }
        return (T)arrayList.get(0);
    }

    public static <T> List<T> rest(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            arrayList.add(t);
        }
        arrayList.remove(0);
        return arrayList;
    }

    public static boolean randomBoolean() {
        int n = r.nextInt(2);
        return n != 0;
    }

    public static double[] normalize(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        double[] dArray2 = new double[n];
        if (d != 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = dArray[i] / d;
            }
        }
        double d3 = 0.0;
        for (double d4 : dArray2) {
            d3 += d4;
        }
        return dArray2;
    }

    public static List<Double> normalize(List<Double> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i);
        }
        double[] dArray2 = Util.normalize(dArray);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < dArray2.length; ++i) {
            arrayList.add(dArray2[i]);
        }
        return arrayList;
    }

    public static int min(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    public static int max(int n, int n2) {
        return n < n2 ? n2 : n;
    }

    public static int max(int n, int n2, int n3) {
        return Util.max(Util.max(n, n2), n3);
    }

    public static int min(int n, int n2, int n3) {
        return Util.min(Util.min(n, n2), n3);
    }

    public static <T> T selectRandomlyFromList(List<T> list) {
        int n = r.nextInt(list.size());
        return list.get(n);
    }

    public static <T> T mode(List<T> list) {
        Hashtable<T, Integer> hashtable = new Hashtable<T, Integer>();
        for (Object object : list) {
            if (hashtable.containsKey(object)) {
                hashtable.put(object, (Integer)hashtable.get(object) + 1);
                continue;
            }
            hashtable.put(object, 1);
        }
        Iterator<Object> iterator = hashtable.keySet().iterator().next();
        for (Object e : hashtable.keySet()) {
            if ((Integer)hashtable.get(e) <= (Integer)hashtable.get(iterator)) continue;
            iterator = e;
        }
        return (T)iterator;
    }

    public static String[] yesno() {
        return new String[]{YES, NO};
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double information(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += -1.0 * Util.log2(d2) * d2;
        }
        return d;
    }

    public static <T> List<T> removeFrom(List<T> list, T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : list) {
            if (t2.equals(t)) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static <T extends Number> double sumOfSquares(List<T> list) {
        double d = 0.0;
        for (Number number : list) {
            d += number.doubleValue() * number.doubleValue();
        }
        return d;
    }

    public static String ntimes(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void checkForNanOrInfinity(double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("Not a Number");
        }
        if (Double.isInfinite(d)) {
            throw new RuntimeException("Infinite Number");
        }
    }

    public static int randomNumberBetween(int n, int n2) {
        return r.nextInt(n2 - n + 1) + n;
    }

    public static double calculateMean(List<Double> list) {
        Double d = 0.0;
        for (Double d2 : list) {
            d = d + d2;
        }
        return d / (double)list.size();
    }

    public static double calculateStDev(List<Double> list, double d) {
        int n = list.size();
        Double d2 = 0.0;
        for (Double d3 : list) {
            double d4 = d3 - d;
            d2 = d2 + d4 * d4 / (double)(n - 1);
        }
        double d5 = d2;
        return Math.sqrt(d5);
    }

    public static List<Double> normalizeFromMeanAndStdev(List<Double> list, double d, double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Double d3 : list) {
            arrayList.add((d3 - d) / d2);
        }
        return arrayList;
    }

    public static double generateRandomDoubleBetween(double d, double d2) {
        return d + (d2 - d) * r.nextDouble();
    }
}

