/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.Hashtable;
import java.util.Set;

public class FrequencyCounter<T> {
    private Hashtable<T, Integer> counter = new Hashtable();

    public Integer getCount(T t) {
        Integer n = this.counter.get(t);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void incrementFor(T t) {
        Integer n = this.counter.get(t);
        if (n == null) {
            this.counter.put(t, 1);
        } else {
            this.counter.put(t, n + 1);
        }
    }

    public Double probabilityOf(T t) {
        Integer n = this.getCount(t);
        if (n == 0) {
            return 0.0;
        }
        Double d = 0.0;
        for (T t2 : this.counter.keySet()) {
            d = d + (double)this.getCount(t2).intValue();
        }
        return (double)n.intValue() / d;
    }

    public String toString() {
        return this.counter.toString();
    }

    public Set<T> getStates() {
        return this.counter.keySet();
    }
}

