/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.ReflexVaccumAgentWithState;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class ReflexVaccumAgentWithStateTest
extends TestCase {
    private ReflexVaccumAgentWithState agent;
    private StringBuffer envChanges;

    public void setUp() {
        this.agent = new ReflexVaccumAgentWithState();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentWithStateTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        ReflexVaccumAgentWithStateTest.assertEquals((String)"RightNoOP", (String)this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Clean", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentWithStateTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        ReflexVaccumAgentWithStateTest.assertEquals((String)"RightSuckNoOP", (String)this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Clean");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentWithStateTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        ReflexVaccumAgentWithStateTest.assertEquals((String)"SuckRightNoOP", (String)this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment trivialVaccumEnvironment = new TrivialVaccumEnvironment("Dirty", "Dirty");
        trivialVaccumEnvironment.addAgent(this.agent, "A");
        trivialVaccumEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                ReflexVaccumAgentWithStateTest.this.envChanges.append(string);
            }
        });
        trivialVaccumEnvironment.stepUntilDone();
        ReflexVaccumAgentWithStateTest.assertEquals((String)"SuckRightSuckNoOP", (String)this.envChanges.toString());
    }
}

