/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.map.ExtendableMap;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class MapTest
extends TestCase {
    ExtendableMap aMap;

    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 7.0);
        this.aMap.addUnidirectionalLink("B", "E", 14.0);
    }

    public void testLocationsLinkedTo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.aMap.getLocationsLinkedTo("A");
        arrayList.clear();
        arrayList.add("B");
        arrayList.add("C");
        MapTest.assertTrue((arrayList.containsAll(list) && list.size() == 2 ? 1 : 0) != 0);
        list = this.aMap.getLocationsLinkedTo("B");
        arrayList.clear();
        arrayList.add("A");
        arrayList.add("C");
        arrayList.add("E");
        MapTest.assertTrue((arrayList.containsAll(list) && list.size() == 3 ? 1 : 0) != 0);
        list = this.aMap.getLocationsLinkedTo("C");
        arrayList.clear();
        arrayList.add("A");
        arrayList.add("B");
        arrayList.add("D");
        MapTest.assertTrue((arrayList.containsAll(list) && list.size() == 3 ? 1 : 0) != 0);
        list = this.aMap.getLocationsLinkedTo("D");
        arrayList.clear();
        arrayList.add("C");
        MapTest.assertTrue((arrayList.containsAll(list) && list.size() == 1 ? 1 : 0) != 0);
        list = this.aMap.getLocationsLinkedTo("E");
        MapTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
    }

    public void testDistances() {
        MapTest.assertEquals((Object)new Double(5.0), (Object)this.aMap.getDistance("A", "B"));
        MapTest.assertEquals((Object)new Double(6.0), (Object)this.aMap.getDistance("A", "C"));
        MapTest.assertEquals((Object)new Double(4.0), (Object)this.aMap.getDistance("B", "C"));
        MapTest.assertEquals((Object)new Double(7.0), (Object)this.aMap.getDistance("C", "D"));
        MapTest.assertEquals((Object)new Double(14.0), (Object)this.aMap.getDistance("B", "E"));
        MapTest.assertEquals((Object)new Double(5.0), (Object)this.aMap.getDistance("B", "A"));
        MapTest.assertEquals((Object)new Double(6.0), (Object)this.aMap.getDistance("C", "A"));
        MapTest.assertEquals((Object)new Double(4.0), (Object)this.aMap.getDistance("C", "B"));
        MapTest.assertEquals((Object)new Double(7.0), (Object)this.aMap.getDistance("D", "C"));
        MapTest.assertNull((Object)this.aMap.getDistance("X", "Z"));
        MapTest.assertNull((Object)this.aMap.getDistance("A", "Z"));
        MapTest.assertNull((Object)this.aMap.getDistance("A", "E"));
        MapTest.assertNull((Object)this.aMap.getDistance("E", "B"));
    }

    public void testRandomGeneration() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("A");
        arrayList.add("B");
        arrayList.add("C");
        arrayList.add("D");
        arrayList.add("E");
        for (int i = 0; i < arrayList.size(); ++i) {
            MapTest.assertTrue((boolean)arrayList.contains(this.aMap.randomlyGenerateDestination()));
        }
    }
}

