/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probabilitytest;

import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import aima.probability.EnumerationAsk;
import aima.probability.Query;
import aima.test.probabilitytest.MockRandomizer;
import java.util.Hashtable;
import junit.framework.TestCase;

public class ProbabilitySamplingTest
extends TestCase {
    public void testPriorSample() {
        BayesNet bayesNet = this.createWetGrassNetwork();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.5, 0.5, 0.5, 0.5});
        Hashtable hashtable = bayesNet.getPriorSample(mockRandomizer);
        ProbabilitySamplingTest.assertEquals((int)4, (int)hashtable.keySet().size());
        ProbabilitySamplingTest.assertEquals((Object)Boolean.TRUE, hashtable.get("Cloudy"));
        ProbabilitySamplingTest.assertEquals((Object)Boolean.FALSE, hashtable.get("Sprinkler"));
        ProbabilitySamplingTest.assertEquals((Object)Boolean.TRUE, hashtable.get("Rain"));
        ProbabilitySamplingTest.assertEquals((Object)Boolean.TRUE, hashtable.get("WetGrass"));
    }

    public void testRejectionSample() {
        BayesNet bayesNet = this.createWetGrassNetwork();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.1});
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.rejectionSample("Rain", hashtable, 100, mockRandomizer);
        ProbabilitySamplingTest.assertEquals((double)1.0, (double)dArray[0], (double)0.001);
        ProbabilitySamplingTest.assertEquals((double)0.0, (double)dArray[1], (double)0.001);
    }

    public void testLikelihoodWeighting() {
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.5, 0.5, 0.5, 0.5});
        BayesNet bayesNet = this.createWetGrassNetwork();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.likelihoodWeighting("Rain", hashtable, 1000, mockRandomizer);
        ProbabilitySamplingTest.assertEquals((double)1.0, (double)dArray[0], (double)0.001);
        ProbabilitySamplingTest.assertEquals((double)0.0, (double)dArray[1], (double)0.001);
    }

    public void testMCMCask() {
        BayesNet bayesNet = this.createWetGrassNetwork();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.5, 0.5, 0.5, 0.5});
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.mcmcAsk("Rain", hashtable, 1, mockRandomizer);
        ProbabilitySamplingTest.assertEquals((double)0.333, (double)dArray[0], (double)0.001);
        ProbabilitySamplingTest.assertEquals((double)0.666, (double)dArray[1], (double)0.001);
    }

    public void testMCMCask2() {
        BayesNet bayesNet = this.createWetGrassNetwork();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.5, 0.5, 0.5, 0.5});
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.mcmcAsk("Rain", hashtable, 1, mockRandomizer);
        ProbabilitySamplingTest.assertEquals((double)0.333, (double)dArray[0], (double)0.001);
        ProbabilitySamplingTest.assertEquals((double)0.666, (double)dArray[1], (double)0.001);
    }

    public void testEnumerationAskinMCMC() {
        BayesNet bayesNet = this.createWetGrassNetwork();
        MockRandomizer mockRandomizer = new MockRandomizer(new double[]{0.5, 0.5, 0.5, 0.5});
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Rain", Boolean.TRUE);
        hashtable.put("Sprinkler", Boolean.TRUE);
        Query query = new Query("Cloudy", new String[]{"Sprinkler", "Rain"}, new boolean[]{true, true});
        double[] dArray = EnumerationAsk.ask(query, bayesNet);
        double[] dArray2 = bayesNet.mcmcAsk("Cloudy", hashtable, 1000);
    }

    private BayesNet createWetGrassNetwork() {
        BayesNetNode bayesNetNode = new BayesNetNode("Cloudy");
        BayesNetNode bayesNetNode2 = new BayesNetNode("Sprinkler");
        BayesNetNode bayesNetNode3 = new BayesNetNode("Rain");
        BayesNetNode bayesNetNode4 = new BayesNetNode("WetGrass");
        bayesNetNode2.influencedBy(bayesNetNode);
        bayesNetNode3.influencedBy(bayesNetNode);
        bayesNetNode4.influencedBy(bayesNetNode3, bayesNetNode2);
        bayesNetNode.setProbability(true, 0.5);
        bayesNetNode2.setProbability(true, 0.1);
        bayesNetNode2.setProbability(false, 0.5);
        bayesNetNode3.setProbability(true, 0.8);
        bayesNetNode3.setProbability(false, 0.2);
        bayesNetNode4.setProbability(true, true, 0.99);
        bayesNetNode4.setProbability(true, false, 0.9);
        bayesNetNode4.setProbability(false, true, 0.9);
        bayesNetNode4.setProbability(false, false, 0.0);
        BayesNet bayesNet = new BayesNet(bayesNetNode);
        return bayesNet;
    }
}

