/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.parser;

import aima.logic.common.Token;
import aima.logic.propositional.parsing.PELexer;
import junit.framework.TestCase;

public class PELexerTest
extends TestCase {
    public void testLexBasicExpression() {
        PELexer pELexer = new PELexer();
        pELexer.setInput("(P)");
        PELexerTest.assertEquals((Object)new Token(2, "("), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(1, "P"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(3, ")"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)pELexer.nextToken());
    }

    public void testLexNotExpression() {
        PELexer pELexer = new PELexer();
        pELexer.setInput("(NOT P)");
        PELexerTest.assertEquals((Object)new Token(2, "("), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(5, "NOT"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(1, "P"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(3, ")"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(9999, "EOI"), (Object)pELexer.nextToken());
    }

    public void testLexImpliesExpression() {
        PELexer pELexer = new PELexer();
        pELexer.setInput("(P => Q)");
        PELexerTest.assertEquals((Object)new Token(2, "("), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(1, "P"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(5, "=>"), (Object)pELexer.nextToken());
    }

    public void testLexBiCOnditionalExpression() {
        PELexer pELexer = new PELexer();
        pELexer.setInput("(B11 <=> (P12 OR P21))");
        PELexerTest.assertEquals((Object)new Token(2, "("), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(1, "B11"), (Object)pELexer.nextToken());
        PELexerTest.assertEquals((Object)new Token(5, "<=>"), (Object)pELexer.nextToken());
    }
}

