/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class FOLParserTest
extends TestCase {
    FOLLexer lexer;
    FOLParser parser;

    public void setUp() {
        FOLDomain fOLDomain = DomainFactory.crusadesDomain();
        this.lexer = new FOLLexer(fOLDomain);
        this.parser = new FOLParser(this.lexer);
    }

    public void testParseSimpleVariable() {
        this.parser.setUpToParse("x");
        Term term = this.parser.parseVariable();
        FOLParserTest.assertEquals((Object)term, (Object)new Variable("x"));
    }

    public void testParseIndexedVariable() {
        this.parser.setUpToParse("x1");
        Term term = this.parser.parseVariable();
        FOLParserTest.assertEquals((Object)term, (Object)new Variable("x1"));
    }

    public void testNotAllowedParseLeadingIndexedVariable() {
        try {
            this.parser.setUpToParse("1x");
            this.parser.parseVariable();
            FOLParserTest.fail((String)"A Runtime Exception should have been thrown, indicating '1x' is not a valid variable name.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testParseSimpleConstant() {
        this.parser.setUpToParse("John");
        Term term = this.parser.parseConstant();
        FOLParserTest.assertEquals((Object)term, (Object)new Constant("John"));
    }

    public void testParseFunction() {
        this.parser.setUpToParse("BrotherOf(John)");
        Term term = this.parser.parseFunction();
        FOLParserTest.assertEquals((Object)term, (Object)this.getBrotherOfFunction(new Constant("John")));
    }

    public void testParseMultiArityFunction() {
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term term = this.parser.parseFunction();
        FOLParserTest.assertEquals((Object)term, (Object)this.getLegsOfFunction());
        FOLParserTest.assertEquals((int)3, (int)((Function)term).getTerms().size());
    }

    public void testPredicate() {
        Predicate predicate = (Predicate)this.parser.parse("King(John)");
        FOLParserTest.assertEquals((Object)predicate, (Object)this.getKingPredicate(new Constant("John")));
    }

    public void testTermEquality() {
        try {
            TermEquality termEquality = (TermEquality)this.parser.parse("BrotherOf(John) = EnemyOf(Saladin)");
            FOLParserTest.assertEquals((Object)termEquality, (Object)new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testTermEquality2() {
        try {
            TermEquality termEquality = (TermEquality)this.parser.parse("BrotherOf(John) = x)");
            FOLParserTest.assertEquals((Object)termEquality, (Object)new TermEquality(this.getBrotherOfFunction(new Constant("John")), new Variable("x")));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNotSentence() {
        NotSentence notSentence = (NotSentence)this.parser.parse("NOT BrotherOf(John) = EnemyOf(Saladin)");
        FOLParserTest.assertEquals((Object)notSentence.getNegated(), (Object)new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction()));
    }

    public void testSimpleParanthizedSentence() {
        Sentence sentence = this.parser.parse("(NOT King(John))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new NotSentence(this.getKingPredicate(new Constant("John"))));
    }

    public void testExtraParanthizedSentence() {
        Sentence sentence = this.parser.parse("(((NOT King(John))))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new NotSentence(this.getKingPredicate(new Constant("John"))));
    }

    public void testParseComplexParanthizedSentence() {
        Sentence sentence = this.parser.parse("(NOT BrotherOf(John) = EnemyOf(Saladin))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new NotSentence(new TermEquality(this.getBrotherOfFunction(new Constant("John")), this.getEnemyOfFunction())));
    }

    public void testParseSimpleConnectedSentence() {
        Sentence sentence = this.parser.parse("(King(John) AND NOT King(Richard))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), new NotSentence(this.getKingPredicate(new Constant("Richard")))));
        sentence = this.parser.parse("(King(John) AND King(Saladin))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), this.getKingPredicate(new Constant("Saladin"))));
    }

    public void testComplexConnectedSentence1() {
        Sentence sentence = this.parser.parse("((King(John) AND NOT King(Richard)) OR King(Saladin))");
        FOLParserTest.assertEquals((Object)sentence, (Object)new ConnectedSentence("OR", new ConnectedSentence("AND", this.getKingPredicate(new Constant("John")), new NotSentence(this.getKingPredicate(new Constant("Richard")))), this.getKingPredicate(new Constant("Saladin"))));
    }

    public void testQuantifiedSentenceWithSingleVariable() {
        Sentence sentence = this.parser.parse("FORALL x  King(x)");
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        arrayList.add(new Variable("x"));
        FOLParserTest.assertEquals((Object)sentence, (Object)new QuantifiedSentence("FORALL", arrayList, this.getKingPredicate(new Variable("x"))));
    }

    public void testQuantifiedSentenceWithTwoVariables() {
        Sentence sentence = this.parser.parse("EXISTS x,y  (King(x) AND BrotherOf(x) = y)");
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        arrayList.add(new Variable("x"));
        arrayList.add(new Variable("y"));
        ConnectedSentence connectedSentence = new ConnectedSentence("AND", this.getKingPredicate(new Variable("x")), new TermEquality(this.getBrotherOfFunction(new Variable("x")), new Variable("y")));
        FOLParserTest.assertEquals((Object)sentence, (Object)new QuantifiedSentence("EXISTS", arrayList, connectedSentence));
    }

    public void testQuantifiedSentenceWithPathologicalParanthising() {
        Sentence sentence = this.parser.parse("(( (EXISTS x,y  (King(x) AND (BrotherOf(x) = y)) ) ))");
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        arrayList.add(new Variable("x"));
        arrayList.add(new Variable("y"));
        ConnectedSentence connectedSentence = new ConnectedSentence("AND", this.getKingPredicate(new Variable("x")), new TermEquality(this.getBrotherOfFunction(new Variable("x")), new Variable("y")));
        FOLParserTest.assertEquals((Object)sentence, (Object)new QuantifiedSentence("EXISTS", arrayList, connectedSentence));
    }

    public Function getBrotherOfFunction(Term term) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term);
        return new Function("BrotherOf", arrayList);
    }

    public Function getEnemyOfFunction() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("Saladin"));
        return new Function("EnemyOf", arrayList);
    }

    public Function getLegsOfFunction() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Constant("John"));
        arrayList.add(new Constant("Saladin"));
        arrayList.add(new Constant("Richard"));
        return new Function("LegsOf", arrayList);
    }

    public Predicate getKingPredicate(Term term) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term);
        return new Predicate("King", arrayList);
    }

    public void testParseMultiArityFunctionEquality() {
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term term = this.parser.parseFunction();
        this.parser.setUpToParse("LegsOf(John,Saladin,Richard)");
        Term term2 = this.parser.parseFunction();
        FOLParserTest.assertEquals((Object)term, (Object)term2);
        FOLParserTest.assertEquals((int)3, (int)((Function)term).getTerms().size());
    }

    public void testConnectedImplication() {
        this.parser = new FOLParser(DomainFactory.weaponsDomain());
        Sentence sentence = this.parser.parse("((Missile(m) AND Owns(Nono,m)) => Sells(West , m ,Nono))");
    }
}

