/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;

public class ClauseTest
extends TestCase {
    public void setUp() {
        StandardizeApartIndexicalFactory.flush();
    }

    public void testImmutable() {
        Clause clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isImmutable());
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        clause.setImmutable();
        ClauseTest.assertTrue((boolean)clause.isImmutable());
        try {
            clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
            ClauseTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            clause.addPositiveLiteral(new Predicate("Pred3", new ArrayList<Term>()));
            ClauseTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        Clause clause = new Clause();
        ClauseTest.assertTrue((boolean)clause.isEmpty());
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isEmpty());
        Clause clause2 = new Clause();
        ClauseTest.assertTrue((boolean)clause2.isEmpty());
        clause2.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause2.isEmpty());
        Clause clause3 = new Clause();
        ClauseTest.assertTrue((boolean)clause3.isEmpty());
        clause3.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause3.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause3.isEmpty());
        clause3.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause3.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause3.isEmpty());
    }

    public void testIsHornClause() {
        Clause clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isHornClause());
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isHornClause());
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isHornClause());
        clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isHornClause());
        clause.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isHornClause());
        clause.addPositiveLiteral(new Predicate("Pred5", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isHornClause());
    }

    public void testIsDefiniteClause() {
        Clause clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isDefiniteClause());
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isDefiniteClause());
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isDefiniteClause());
        clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isDefiniteClause());
        clause.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isDefiniteClause());
        clause.addPositiveLiteral(new Predicate("Pred5", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isDefiniteClause());
    }

    public void testIsUnitClause() {
        Clause clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isUnitClause());
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
        clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isUnitClause());
        clause.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
        clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isUnitClause());
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isUnitClause());
    }

    public void testIsImplicationDefiniteClause() {
        Clause clause = new Clause();
        ClauseTest.assertFalse((boolean)clause.isImplicationDefiniteClause());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isImplicationDefiniteClause());
        clause.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isImplicationDefiniteClause());
        clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue((boolean)clause.isImplicationDefiniteClause());
        clause.addPositiveLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertFalse((boolean)clause.isImplicationDefiniteClause());
    }

    public void testBinaryResolvents() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("Pred1");
        fOLDomain.addPredicate("Pred2");
        fOLDomain.addPredicate("Pred3");
        fOLDomain.addPredicate("Pred4");
        Clause clause = new Clause();
        ClauseTest.assertNotNull(clause.binaryResolvents(clause));
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause).size());
        ClauseTest.assertTrue((boolean)clause.binaryResolvents(clause).iterator().next().isEmpty());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertNotNull(clause.binaryResolvents(clause));
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause).size());
        ClauseTest.assertEquals((String)"[~Pred1(), Pred1()]", (String)clause.binaryResolvents(clause).iterator().next().toString());
        clause = new Clause();
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertEquals((int)0, (int)clause.binaryResolvents(clause).size());
        clause = new Clause();
        Clause clause2 = new Clause();
        ClauseTest.assertNotNull(clause.binaryResolvents(clause2));
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause2).size());
        ClauseTest.assertTrue((boolean)clause.binaryResolvents(clause2).iterator().next().isEmpty());
        ClauseTest.assertNotNull(clause2.binaryResolvents(clause));
        ClauseTest.assertEquals((int)1, (int)clause2.binaryResolvents(clause).size());
        ClauseTest.assertTrue((boolean)clause2.binaryResolvents(clause).iterator().next().isEmpty());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause2.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertNotNull(clause.binaryResolvents(clause2));
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause2).size());
        ClauseTest.assertTrue((boolean)clause.binaryResolvents(clause2).iterator().next().isEmpty());
        ClauseTest.assertNotNull(clause2.binaryResolvents(clause));
        ClauseTest.assertEquals((int)1, (int)clause2.binaryResolvents(clause).size());
        ClauseTest.assertTrue((boolean)clause2.binaryResolvents(clause).iterator().next().isEmpty());
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause2.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        clause2.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertNotNull(clause.binaryResolvents(clause2));
        ClauseTest.assertEquals((int)2, (int)clause.binaryResolvents(clause2).size());
        ClauseTest.assertNotNull(clause2.binaryResolvents(clause));
        ClauseTest.assertEquals((int)2, (int)clause2.binaryResolvents(clause).size());
        clause = new Clause();
        clause2 = new Clause();
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        clause.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        clause2.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        clause2.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertNotNull(clause.binaryResolvents(clause2));
        ClauseTest.assertEquals((int)0, (int)clause.binaryResolvents(clause2).size());
        ClauseTest.assertNotNull(clause2.binaryResolvents(clause));
        ClauseTest.assertEquals((int)0, (int)clause2.binaryResolvents(clause).size());
        clause = new Clause();
        clause2 = new Clause();
        clause.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        clause.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        clause.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        clause2.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertNotNull(clause.binaryResolvents(clause2));
        ClauseTest.assertNotNull(clause2.binaryResolvents(clause));
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause2).iterator().next().getNumberPositiveLiterals());
        ClauseTest.assertEquals((int)1, (int)clause.binaryResolvents(clause2).iterator().next().getNumberNegativeLiterals());
        ClauseTest.assertEquals((int)1, (int)clause2.binaryResolvents(clause).iterator().next().getNumberPositiveLiterals());
        ClauseTest.assertEquals((int)1, (int)clause2.binaryResolvents(clause).iterator().next().getNumberNegativeLiterals());
    }

    public void testBinaryResolventsOrderDoesNotMatter() {
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(DomainFactory.lovesAnimalDomain());
        fOLKnowledgeBase.tell("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        fOLKnowledgeBase.tell("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        fOLKnowledgeBase.tell("FORALL x (Animal(x) => Loves(Jack, x))");
        fOLKnowledgeBase.tell("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        fOLKnowledgeBase.tell("Cat(Tuna)");
        fOLKnowledgeBase.tell("FORALL x (Cat(x) => Animal(x))");
        LinkedHashSet<Clause> linkedHashSet = new LinkedHashSet<Clause>();
        linkedHashSet.addAll(fOLKnowledgeBase.getAllClauses());
        LinkedHashSet<Clause> linkedHashSet2 = new LinkedHashSet<Clause>();
        long l = 30000L;
        long l2 = System.currentTimeMillis() + l;
        block0: do {
            linkedHashSet.addAll(linkedHashSet2);
            linkedHashSet2.clear();
            Clause[] clauseArray = new Clause[linkedHashSet.size()];
            linkedHashSet.toArray(clauseArray);
            for (int i = 0; i < clauseArray.length; ++i) {
                Clause clause = clauseArray[i];
                for (int j = 0; j < clauseArray.length; ++j) {
                    Clause clause2 = clauseArray[j];
                    linkedHashSet2.addAll(clause.getFactors());
                    linkedHashSet2.addAll(clause2.getFactors());
                    Set<Clause> set = clause.binaryResolvents(clause2);
                    Set<Clause> set2 = clause2.binaryResolvents(clause);
                    if (!((Object)set).equals(set2)) {
                        System.err.println("cI=" + clause);
                        System.err.println("cJ=" + clause2);
                        System.err.println("cIR=" + set);
                        System.err.println("cJR=" + set2);
                        ClauseTest.fail((String)"Ordering of binary resolvents has become important, which should not be the case");
                    }
                    for (Clause clause3 : set) {
                        linkedHashSet2.addAll(clause3.getFactors());
                    }
                    if (System.currentTimeMillis() > l2) break;
                }
                if (System.currentTimeMillis() > l2) continue block0;
            }
        } while (System.currentTimeMillis() < l2);
    }

    public void testEqualityBinaryResolvents() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Clause clause = new Clause();
        clause.addPositiveLiteral((AtomicSentence)fOLParser.parse("B = A"));
        Clause clause2 = new Clause();
        clause2.addNegativeLiteral((AtomicSentence)fOLParser.parse("B = A"));
        clause2.addPositiveLiteral((AtomicSentence)fOLParser.parse("B = A"));
        Set<Clause> set = clause.binaryResolvents(clause2);
        ClauseTest.assertEquals((int)1, (int)set.size());
        ClauseTest.assertEquals((String)"[[B = A]]", (String)set.toString());
    }

    public void testHashCode() {
        Constant constant = new Constant("C1");
        Constant constant2 = new Constant("C2");
        Variable variable = new Variable("v1");
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        arrayList.add(constant);
        arrayList.add(constant2);
        arrayList.add(variable);
        arrayList2.add(constant2);
        arrayList2.add(constant);
        arrayList2.add(variable);
        Clause clause = new Clause();
        Clause clause2 = new Clause();
        ClauseTest.assertEquals((int)clause.hashCode(), (int)clause2.hashCode());
        clause.addNegativeLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertNotSame((Object)clause.hashCode(), (Object)clause2.hashCode());
        clause2.addNegativeLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertEquals((int)clause.hashCode(), (int)clause2.hashCode());
        clause.addPositiveLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertNotSame((Object)clause.hashCode(), (Object)clause2.hashCode());
        clause2.addPositiveLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertEquals((int)clause.hashCode(), (int)clause2.hashCode());
    }

    public void testSimpleEquals() {
        Constant constant = new Constant("C1");
        Constant constant2 = new Constant("C2");
        Variable variable = new Variable("v1");
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        arrayList.add(constant);
        arrayList.add(constant2);
        arrayList.add(variable);
        arrayList2.add(constant2);
        arrayList2.add(constant);
        arrayList2.add(variable);
        Clause clause = new Clause();
        Clause clause2 = new Clause();
        ClauseTest.assertTrue((boolean)clause.equals(clause));
        ClauseTest.assertTrue((boolean)clause2.equals(clause2));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addNegativeLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addNegativeLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addNegativeLiteral(new Predicate("Pred2", arrayList2));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addNegativeLiteral(new Predicate("Pred2", arrayList2));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addNegativeLiteral(new Predicate("Pred3", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause.addNegativeLiteral(new Predicate("Pred4", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addNegativeLiteral(new Predicate("Pred4", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addNegativeLiteral(new Predicate("Pred3", arrayList));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addPositiveLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addPositiveLiteral(new Predicate("Pred1", arrayList));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addPositiveLiteral(new Predicate("Pred2", arrayList2));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addPositiveLiteral(new Predicate("Pred2", arrayList2));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
        clause.addPositiveLiteral(new Predicate("Pred3", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause.addPositiveLiteral(new Predicate("Pred4", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addPositiveLiteral(new Predicate("Pred4", arrayList));
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        ClauseTest.assertFalse((boolean)clause2.equals(clause));
        clause2.addPositiveLiteral(new Predicate("Pred3", arrayList));
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        ClauseTest.assertTrue((boolean)clause2.equals(clause));
    }

    public void testComplexEquals() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Animal");
        fOLDomain.addPredicate("Kills");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("SF0");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        Sentence sentence = fOLParser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        Sentence sentence2 = fOLParser.parse("((x2 = y2 AND F(y2) = z2) => F(x2) = z2)");
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNF cNF2 = cNFConverter.convertToCNF(sentence2);
        Clause clause = cNF.getConjunctionOfClauses().get(0);
        Clause clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        sentence2 = fOLParser.parse("((x2 = y2 AND y2 = z2) => x2 = z2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        sentence2 = fOLParser.parse("((y2 = z2 AND x2 = y2) => x2 = z2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        sentence2 = fOLParser.parse("(((x2 = y2 AND y2 = z2) AND z2 = r2) => x2 = r2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        sentence2 = fOLParser.parse("(((z2 = r2 AND y2 = z2) AND x2 = y2) => x2 = r2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        sentence2 = fOLParser.parse("(((x2 = y2 AND y2 = z2) AND z2 = y2) => x2 = r2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertFalse((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("(((((x1 = y1 AND y1 = z1) AND z1 = r1) AND r1 = q1) AND q1 = s1) => x1 = r1)");
        sentence2 = fOLParser.parse("(((((x2 = y2 AND y2 = z2) AND z2 = r2) AND r2 = q2) AND q2 = s2) => x2 = r2)");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
        sentence = fOLParser.parse("((((NOT(Animal(c1920)) OR NOT(Animal(c1921))) OR NOT(Kills(c1922,c1920))) OR NOT(Kills(c1919,c1921))) OR NOT(Kills(SF0(c1922),SF0(c1919))))");
        sentence2 = fOLParser.parse("((((NOT(Animal(c1929)) OR NOT(Animal(c1928))) OR NOT(Kills(c1927,c1929))) OR NOT(Kills(c1930,c1928))) OR NOT(Kills(SF0(c1930),SF0(c1927))))");
        cNF = cNFConverter.convertToCNF(sentence);
        cNF2 = cNFConverter.convertToCNF(sentence2);
        clause = cNF.getConjunctionOfClauses().get(0);
        clause2 = cNF2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue((boolean)clause.equals(clause2));
    }

    public void testNonTrivialFactors() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addFunction("F");
        fOLDomain.addFunction("G");
        fOLDomain.addFunction("H");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Clause clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x,y)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(B,A)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(y,x)"));
        ClauseTest.assertEquals((String)"[[~P(B,A), P(B,A), Q(A,B)]]", (String)clause.getNonTrivialFactors().toString());
        clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x,y)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(B,A)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("Q(y,x)"));
        ClauseTest.assertEquals((String)"[]", (String)clause.getNonTrivialFactors().toString());
        clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x,F(y))"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(G(u),x)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(F(y),u)"));
        clause = clause.getNonTrivialFactors().iterator().next();
        Literal literal = clause.getPositiveLiterals().get(0);
        ClauseTest.assertEquals((String)"P", (String)literal.getAtomicSentence().getSymbolicName());
        Function function = (Function)literal.getAtomicSentence().getArgs().get(0);
        ClauseTest.assertEquals((String)"F", (String)function.getFunctionName());
        Variable variable = (Variable)function.getTerms().get(0);
        function = (Function)literal.getAtomicSentence().getArgs().get(1);
        ClauseTest.assertEquals((String)"F", (String)function.getFunctionName());
        ClauseTest.assertEquals((Object)variable, (Object)function.getTerms().get(0));
        literal = clause.getPositiveLiterals().get(1);
        function = (Function)literal.getAtomicSentence().getArgs().get(0);
        ClauseTest.assertEquals((String)"G", (String)function.getFunctionName());
        function = (Function)function.getTerms().get(0);
        ClauseTest.assertEquals((String)"F", (String)function.getFunctionName());
        ClauseTest.assertEquals((Object)variable, (Object)function.getTerms().get(0));
        function = (Function)literal.getAtomicSentence().getArgs().get(1);
        ClauseTest.assertEquals((String)"F", (String)function.getFunctionName());
        ClauseTest.assertEquals((Object)variable, (Object)function.getTerms().get(0));
        clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(G(x))"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(x)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(F(A))"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(G(F(x)))"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(F(A))"));
        ClauseTest.assertEquals((String)"[[P(F(A)), P(G(F(F(A)))), P(G(F(A))), Q(F(A))]]", (String)clause.getNonTrivialFactors().toString());
    }

    public void testIsTautology() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("R");
        fOLDomain.addFunction("F");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Clause clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(F(A))"));
        ClauseTest.assertFalse((boolean)clause.isTautology());
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(F(A))"));
        ClauseTest.assertTrue((boolean)clause.isTautology());
        clause = new Clause();
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x)"));
        ClauseTest.assertFalse((boolean)clause.isTautology());
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(y)"));
        ClauseTest.assertFalse((boolean)clause.isTautology());
        clause.addNegativeLiteral((Predicate)fOLParser.parse("Q(y)"));
        ClauseTest.assertTrue((boolean)clause.isTautology());
        clause.addPositiveLiteral((Predicate)fOLParser.parse("R(z)"));
        ClauseTest.assertTrue((boolean)clause.isTautology());
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A)"));
        ClauseTest.assertFalse((boolean)clause.isTautology());
        clause.addPositiveLiteral((Predicate)fOLParser.parse("P(x)"));
        ClauseTest.assertFalse((boolean)clause.isTautology());
    }

    public void testSubsumes() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addConstant("E");
        fOLDomain.addConstant("F");
        fOLDomain.addConstant("G");
        fOLDomain.addConstant("H");
        fOLDomain.addConstant("I");
        fOLDomain.addConstant("J");
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Clause clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        Clause clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(x,y)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(x,B)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(x)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,y)"));
        ClauseTest.assertFalse((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(x,B)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(z)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,y)"));
        ClauseTest.assertFalse((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(w,z)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(x,y)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(v,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(w,z)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(x,y)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        ClauseTest.assertFalse((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(x,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        ClauseTest.assertFalse((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,x)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C,D)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(E,F)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause2.addPositiveLiteral((Predicate)fOLParser.parse("Q(E,F)"));
        clause2.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        ClauseTest.assertTrue((boolean)clause2.subsumes(clause));
        clause = new Clause();
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(C,D)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(E,F)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(G,H)"));
        clause.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(C,D)"));
        clause.addPositiveLiteral((Predicate)fOLParser.parse("Q(E,F)"));
        clause2 = new Clause();
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(I,J)"));
        clause2.addNegativeLiteral((Predicate)fOLParser.parse("P(A,B)"));
        clause2.addPositiveLiteral((Predicate)fOLParser.parse("Q(E,A)"));
        clause2.addPositiveLiteral((Predicate)fOLParser.parse("Q(A,B)"));
        ClauseTest.assertFalse((boolean)clause2.subsumes(clause));
    }
}

