/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DecisionList;
import junit.framework.TestCase;

public class DecisionListTest
extends TestCase {
    public void testDecisonListWithNoTestsReturnsDefaultValue() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DecisionListTest.assertEquals((String)"No", (String)decisionList.predict(dataSet.getExample(0)));
    }

    public void testDecisionListWithSingleTestReturnsTestValueIfTestSuccessful() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "French");
        decisionList.add(dLTest, "test1success");
        DecisionListTest.assertEquals((String)"test1success", (String)decisionList.predict(dataSet.getExample(0)));
    }

    public void testDecisionListFallsThruToNextTestIfOneDoesntMatch() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Thai");
        decisionList.add(dLTest, "test1success");
        DLTest dLTest2 = new DLTest();
        dLTest2.add("type", "French");
        decisionList.add(dLTest2, "test2success");
        DecisionListTest.assertEquals((String)"test2success", (String)decisionList.predict(dataSet.getExample(0)));
    }

    public void testDecisionListFallsThruToDefaultIfNoTestMatches() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Thai");
        decisionList.add(dLTest, "test1success");
        DLTest dLTest2 = new DLTest();
        dLTest2.add("type", "Burger");
        decisionList.add(dLTest2, "test2success");
        DecisionListTest.assertEquals((String)"No", (String)decisionList.predict(dataSet.getExample(0)));
    }

    public void testDecisionListHandlesEmptyDataSet() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Thai");
        decisionList.add(dLTest, "test1success");
    }

    public void testDecisionListMerge() throws Exception {
        DecisionList decisionList = new DecisionList("Yes", "No");
        DecisionList decisionList2 = new DecisionList("Yes", "No");
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Thai");
        decisionList.add(dLTest, "test1success");
        DLTest dLTest2 = new DLTest();
        dLTest2.add("type", "French");
        decisionList2.add(dLTest2, "test2success");
        DecisionList decisionList3 = decisionList.mergeWith(decisionList2);
        DecisionListTest.assertEquals((String)"test2success", (String)decisionList3.predict(dataSet.getExample(0)));
    }
}

