/*
 * Decompiled with CFR 0.152.
 */
package aima.test.coretest;

import aima.basic.Agent;
import aima.basic.MockAgent;
import aima.basic.Wall;
import aima.basic.XYEnvironment;
import aima.basic.XYLocation;
import java.util.ArrayList;
import junit.framework.TestCase;

public class XYEnvironmentTest
extends TestCase {
    XYEnvironment env;
    Agent a;
    private static String LOCATION = XYEnvironment.LOCATION;

    public XYEnvironmentTest(String string) {
        super(string);
    }

    public void setUp() {
        this.env = new XYEnvironment(10, 12);
        this.a = new MockAgent();
        this.env.addAgent(this.a, new XYLocation(3, 4));
    }

    public void testAddObject() {
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getAgents().size());
        XYEnvironmentTest.assertEquals((Object)new XYLocation(3, 4), (Object)this.a.getAttribute(LOCATION));
    }

    public void testAddObject2() {
        this.env.addObject(new Wall(), new XYLocation(9, 9));
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getAgents().size());
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getObjects().size());
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getObjectsAt(new XYLocation(9, 9)).size());
    }

    public void testAddObjectTwice() {
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getAgents().size());
        XYLocation xYLocation = new XYLocation(5, 5);
        XYLocation xYLocation2 = new XYLocation(6, 6);
        MockAgent mockAgent = new MockAgent();
        this.env.addAgent(mockAgent, xYLocation);
        XYEnvironmentTest.assertEquals((int)2, (int)this.env.getAgents().size());
        XYEnvironmentTest.assertEquals((Object)xYLocation, (Object)mockAgent.getAttribute(LOCATION));
    }

    public void testAbsoluteMoveObject() {
        XYLocation xYLocation = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, xYLocation);
        XYEnvironmentTest.assertEquals((Object)new XYLocation(5, 5), (Object)this.a.getAttribute(LOCATION));
    }

    public void testMoveObject() {
        XYLocation xYLocation = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, xYLocation);
        XYEnvironmentTest.assertEquals((Object)new XYLocation(5, 5), (Object)this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "North");
        XYEnvironmentTest.assertEquals((Object)new XYLocation(5, 4), (Object)this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "East");
        XYEnvironmentTest.assertEquals((Object)new XYLocation(6, 4), (Object)this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "South");
        XYEnvironmentTest.assertEquals((Object)new XYLocation(6, 5), (Object)this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "West");
        XYEnvironmentTest.assertEquals((Object)new XYLocation(5, 5), (Object)this.a.getAttribute(LOCATION));
    }

    public void testIsBlocked() {
        XYLocation xYLocation = new XYLocation(5, 5);
        XYEnvironmentTest.assertEquals((int)0, (int)this.env.getObjectsAt(xYLocation).size());
        XYEnvironmentTest.assertEquals((boolean)false, (boolean)this.env.isBlocked(xYLocation));
        this.env.addObject(new Wall(), xYLocation);
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getObjectsAt(xYLocation).size());
        XYEnvironmentTest.assertEquals((boolean)true, (boolean)this.env.isBlocked(xYLocation));
    }

    public void testMoveWithBlockingWalls() {
        XYLocation xYLocation = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, xYLocation);
        XYLocation xYLocation2 = new XYLocation(5, 6);
        XYLocation xYLocation3 = new XYLocation(5, 4);
        XYLocation xYLocation4 = new XYLocation(4, 5);
        this.env.addObject(new Wall(), xYLocation2);
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(xYLocation2));
        this.env.addObject(new Wall(), xYLocation3);
        this.env.addObject(new Wall(), xYLocation4);
        XYEnvironmentTest.assertEquals((int)3, (int)this.env.getObjects().size());
        this.env.moveObject(this.a, "North");
        this.env.moveObject(this.a, "South");
        this.env.moveObject(this.a, "West");
        this.env.moveObject(this.a, "East");
        XYEnvironmentTest.assertEquals((Object)new XYLocation(6, 5), (Object)this.a.getAttribute(LOCATION));
    }

    public void testGetObjectsAt() {
        XYLocation xYLocation = new XYLocation(5, 7);
        this.env.moveObjectToAbsoluteLocation(this.a, xYLocation);
        XYEnvironmentTest.assertEquals((int)1, (int)this.env.getObjectsAt(xYLocation).size());
        MockAgent mockAgent = new MockAgent();
        this.env.addAgent(mockAgent, xYLocation);
        XYEnvironmentTest.assertEquals((int)2, (int)this.env.getObjectsAt(xYLocation).size());
    }

    public void testGetObjectsNear() {
        XYLocation xYLocation = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, xYLocation);
        MockAgent mockAgent = new MockAgent();
        MockAgent mockAgent2 = new MockAgent();
        Wall wall = new Wall();
        this.env.addAgent(mockAgent, new XYLocation(7, 4));
        this.env.addAgent(mockAgent2, new XYLocation(5, 7));
        this.env.addObject(wall, new XYLocation(3, 10));
        ArrayList arrayList = this.env.getObjectsNear(this.a, 3);
        XYEnvironmentTest.assertEquals((int)2, (int)arrayList.size());
        ArrayList arrayList2 = this.env.getObjectsNear(mockAgent, 3);
        XYEnvironmentTest.assertEquals((int)1, (int)arrayList2.size());
        this.env.moveObject(mockAgent, "North");
        this.env.moveObject(mockAgent, "West");
        arrayList2 = this.env.getObjectsNear(mockAgent, 3);
        XYEnvironmentTest.assertEquals((int)1, (int)arrayList2.size());
        this.env.moveObjectToAbsoluteLocation(mockAgent2, new XYLocation(3, 11));
        ArrayList arrayList3 = this.env.getObjectsNear(mockAgent, 3);
        XYEnvironmentTest.assertEquals((int)1, (int)arrayList3.size());
    }

    public void testMakePerimeter() {
        this.env.makePerimeter();
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(0, 0)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(0, 6)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(0, 11)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(6, 0)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(9, 0)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(9, 6)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(9, 11)));
        XYEnvironmentTest.assertTrue((boolean)this.env.isBlocked(new XYLocation(6, 11)));
    }
}

