/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nqueens;

import aima.basic.XYLocation;
import aima.search.framework.GoalTest;
import aima.search.informed.ga.FitnessFunction;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class NQueensFitnessFunction
implements FitnessFunction,
GoalTest {
    private final NQueensGoalTest goalTest = new NQueensGoalTest();

    @Override
    public Double getValue(String string) {
        double d = 0.0;
        NQueensBoard nQueensBoard = this.getBoardForIndividual(string);
        int n = nQueensBoard.getSize();
        List<XYLocation> list = nQueensBoard.getQueenPositions();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2 = list.get(i).getYCoOrdinate();
                boolean bl = true;
                int n3 = n2;
                if (nQueensBoard.queenExistsAt(new XYLocation(j, n3))) {
                    bl = false;
                }
                if ((n3 = n2 - (j - i)) >= 0 && nQueensBoard.queenExistsAt(new XYLocation(j, n3))) {
                    bl = false;
                }
                if ((n3 = n2 + (j - i)) < n && nQueensBoard.queenExistsAt(new XYLocation(j, n3))) {
                    bl = false;
                }
                if (!bl) continue;
                d += 1.0;
            }
        }
        return d;
    }

    @Override
    public boolean isGoalState(Object object) {
        return this.goalTest.isGoalState(this.getBoardForIndividual((String)object));
    }

    public NQueensBoard getBoardForIndividual(String string) {
        int n = string.length();
        NQueensBoard nQueensBoard = new NQueensBoard(n);
        for (int i = 0; i < n; ++i) {
            int n2 = Character.digit(string.charAt(i), string.length());
            nQueensBoard.addQueenAt(new XYLocation(i, n2));
        }
        return nQueensBoard;
    }

    public String generateRandomIndividual(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        assert (n >= 2 && n <= 36);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Character.forDigit(new Random().nextInt(n), n));
        }
        return stringBuffer.toString();
    }

    public Set<Character> getFiniteAlphabetForBoardOfSize(int n) {
        HashSet<Character> hashSet = new HashSet<Character>();
        assert (n >= 2 && n <= 36);
        for (int i = 0; i < n; ++i) {
            hashSet.add(Character.valueOf(Character.forDigit(i, n)));
        }
        return hashSet;
    }
}

