/*
 * Decompiled with CFR 0.152.
 */
package aima.search.map;

import aima.basic.Percept;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SimpleProblemSolvingAgent;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.MapEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MapAgent
extends SimpleProblemSolvingAgent {
    private MapEnvironment mapEnvironment = null;
    private Search search = null;
    private String currentLocation = null;
    private String[] goalTests = null;
    private int goalTestPos = 0;
    private HeuristicFunction heuristicFunction = null;

    public MapAgent(MapEnvironment mapEnvironment, Search search) {
        this.mapEnvironment = mapEnvironment;
        this.search = search;
    }

    public MapAgent(MapEnvironment mapEnvironment, Search search, int n) {
        super(n);
        this.mapEnvironment = mapEnvironment;
        this.search = search;
    }

    public MapAgent(MapEnvironment mapEnvironment, Search search, String[] stringArray) {
        super(stringArray.length);
        this.mapEnvironment = mapEnvironment;
        this.search = search;
        this.goalTests = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.goalTests, 0, stringArray.length);
    }

    public HeuristicFunction getHeuristicFunction() {
        return this.heuristicFunction;
    }

    public void setHeuristicFunction(HeuristicFunction heuristicFunction) {
        this.heuristicFunction = heuristicFunction;
    }

    @Override
    protected Object updateState(Percept percept) {
        this.currentLocation = (String)percept.getAttribute("In");
        return this.currentLocation;
    }

    @Override
    protected Object formulateGoal() {
        String string = null;
        if (null == this.goalTests) {
            string = this.mapEnvironment.getMap().randomlyGenerateDestination();
        } else {
            string = this.goalTests[this.goalTestPos];
            ++this.goalTestPos;
        }
        this.mapEnvironment.updateViews("CurrentLocation=In(" + this.currentLocation + "), Goal=In(" + string + ")");
        return string;
    }

    @Override
    protected Problem formulateProblem(Object object) {
        if (null == this.getHeuristicFunction()) {
            return new BidirectionalMapProblem(this.mapEnvironment.getMap(), this.currentLocation, (String)object);
        }
        return new BidirectionalMapProblem(this.mapEnvironment.getMap(), this.currentLocation, (String)object, this.getHeuristicFunction());
    }

    @Override
    protected List<String> search(Problem problem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List list = this.search.search(problem);
            for (Object e : list) {
                arrayList.add((String)e);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    protected void notifyViewOfMetrics() {
        Set set = this.search.getMetrics().keySet();
        for (Object e : set) {
            this.mapEnvironment.updateViews("METRIC[" + e + "]=" + this.search.getMetrics().get((String)e));
        }
    }
}

