/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.informed.Scheduler;
import aima.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SimulatedAnnealingSearch
extends NodeExpander
implements Search {
    private final Scheduler scheduler;
    private SearchOutcome outcome = SearchOutcome.FAILURE;
    private Object lastState = null;

    public SimulatedAnnealingSearch() {
        this.scheduler = new Scheduler();
    }

    @Override
    public List<String> search(Problem problem) throws Exception {
        this.clearInstrumentation();
        this.outcome = SearchOutcome.FAILURE;
        this.lastState = null;
        Node node = new Node(problem.getInitialState());
        Node node2 = null;
        ArrayList<String> arrayList = new ArrayList();
        int n = 0;
        while (true) {
            double d;
            double d2 = this.scheduler.getTemp(n);
            ++n;
            if (d2 == 0.0) {
                if (problem.isGoalState(node.getState())) {
                    this.outcome = SearchOutcome.SOLUTION_FOUND;
                }
                break;
            }
            List<Node> list = this.expandNode(node, problem);
            if (list.size() <= 0 || !this.shouldAccept(d2, d = this.getValue(problem, node2 = Util.selectRandomlyFromList(list)) - this.getValue(problem, node))) continue;
            node = node2;
        }
        arrayList = SearchUtils.actionsFromNodes(node.getPathFromRoot());
        this.lastState = node.getState();
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldAccept(double d, double d2) {
        if (d2 > 0.0) return true;
        Random random = new Random();
        if (!(random.nextDouble() <= this.probabilityOfAcceptance(d, d2))) return false;
        return true;
    }

    public double probabilityOfAcceptance(double d, double d2) {
        return Math.exp(d2 / d);
    }

    public SearchOutcome getOutcome() {
        return this.outcome;
    }

    public Object getLastSearchState() {
        return this.lastState;
    }

    private double getValue(Problem problem, Node node) {
        return -1.0 * this.getHeuristic(problem, node);
    }

    private double getHeuristic(Problem problem, Node node) {
        return problem.getHeuristicFunction().getHeuristicValue(node.getState());
    }

    public static enum SearchOutcome {
        FAILURE,
        SOLUTION_FOUND;

    }
}

