/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.Metrics;
import aima.search.framework.Node;
import aima.search.framework.Problem;
import aima.search.framework.Successor;
import java.util.ArrayList;
import java.util.List;

public class NodeExpander {
    protected Metrics metrics = new Metrics();
    protected static String NODES_EXPANDED = "nodesExpanded";

    public void clearInstrumentation() {
        this.metrics.set(NODES_EXPANDED, 0);
    }

    public List<Node> expandNode(Node node, Problem problem) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List list = problem.getSuccessorFunction().getSuccessors(node.getState());
        for (int i = 0; i < list.size(); ++i) {
            Successor successor = (Successor)list.get(i);
            Node node2 = new Node(node, successor.getState());
            node2.setAction(successor.getAction());
            Double d = problem.getStepCostFunction().calculateStepCost(node.getState(), successor.getState(), successor.getAction());
            node2.setStepCost(d);
            node2.addToPathCost(d);
            arrayList.add(node2);
        }
        this.metrics.set(NODES_EXPANDED, this.metrics.getInt(NODES_EXPANDED) + 1);
        return arrayList;
    }

    public int getNodesExpanded() {
        return this.metrics.getInt(NODES_EXPANDED);
    }

    public void setNodesExpanded(int n) {
        this.metrics.set(NODES_EXPANDED, n);
    }

    public Object getSearchMetric(String string) {
        return this.metrics.get(string);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

