/*
 * Decompiled with CFR 0.152.
 */
package aima.search.demos;

import aima.search.eightpuzzle.EightPuzzleBoard;
import aima.search.eightpuzzle.EightPuzzleGoalTest;
import aima.search.eightpuzzle.EightPuzzleSuccessorFunction;
import aima.search.eightpuzzle.ManhattanHeuristicFunction;
import aima.search.eightpuzzle.MisplacedTilleHeuristicFunction;
import aima.search.framework.GoalTest;
import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.SuccessorFunction;
import aima.search.informed.AStarSearch;
import aima.search.informed.GreedyBestFirstSearch;
import aima.search.informed.SimulatedAnnealingSearch;
import aima.search.uninformed.DepthLimitedSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import java.util.List;
import java.util.Properties;

public class EightPuzzleDemo {
    static EightPuzzleBoard boardWithThreeMoveSolution = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 4, 0, 6, 7, 8});
    static EightPuzzleBoard random1 = new EightPuzzleBoard(new int[]{1, 4, 2, 7, 5, 8, 3, 0, 6});
    static EightPuzzleBoard extreme = new EightPuzzleBoard(new int[]{0, 8, 7, 6, 5, 4, 3, 2, 1});

    public static void main(String[] stringArray) {
        EightPuzzleDemo.eightPuzzleDLSDemo();
        EightPuzzleDemo.eightPuzzleIDLSDemo();
        EightPuzzleDemo.eightPuzzleGreedyBestFirstDemo();
        EightPuzzleDemo.eightPuzzleGreedyBestFirstManhattanDemo();
        EightPuzzleDemo.eightPuzzleAStarDemo();
        EightPuzzleDemo.eightPuzzleAStarManhattanDemo();
        EightPuzzleDemo.eightPuzzleSimulatedAnnealingDemo();
    }

    private static void eightPuzzleDLSDemo() {
        System.out.println("\nEightPuzzleDemo recursive DLS -->");
        try {
            Problem problem = new Problem(random1, new EightPuzzleSuccessorFunction(), new EightPuzzleGoalTest());
            DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(9);
            SearchAgent searchAgent = new SearchAgent(problem, depthLimitedSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleIDLSDemo() {
        System.out.println("\nEightPuzzleDemo Iterative DLS -->");
        try {
            Problem problem = new Problem(random1, new EightPuzzleSuccessorFunction(), new EightPuzzleGoalTest());
            IterativeDeepeningSearch iterativeDeepeningSearch = new IterativeDeepeningSearch();
            SearchAgent searchAgent = new SearchAgent(problem, iterativeDeepeningSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleGreedyBestFirstDemo() {
        System.out.println("\nEightPuzzleDemo Greedy Best First Search (MisplacedTileHeursitic)-->");
        try {
            Problem problem = new Problem((Object)boardWithThreeMoveSolution, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new MisplacedTilleHeuristicFunction());
            GreedyBestFirstSearch greedyBestFirstSearch = new GreedyBestFirstSearch(new GraphSearch());
            SearchAgent searchAgent = new SearchAgent(problem, greedyBestFirstSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleGreedyBestFirstManhattanDemo() {
        System.out.println("\nEightPuzzleDemo Greedy Best First Search (ManhattanHeursitic)-->");
        try {
            Problem problem = new Problem((Object)boardWithThreeMoveSolution, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            GreedyBestFirstSearch greedyBestFirstSearch = new GreedyBestFirstSearch(new GraphSearch());
            SearchAgent searchAgent = new SearchAgent(problem, greedyBestFirstSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleAStarDemo() {
        System.out.println("\nEightPuzzleDemo AStar Search (MisplacedTileHeursitic)-->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new MisplacedTilleHeuristicFunction());
            AStarSearch aStarSearch = new AStarSearch(new GraphSearch());
            SearchAgent searchAgent = new SearchAgent(problem, aStarSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleSimulatedAnnealingDemo() {
        System.out.println("\nEightPuzzleDemo Simulated Annealing  Search -->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            SimulatedAnnealingSearch simulatedAnnealingSearch = new SimulatedAnnealingSearch();
            SearchAgent searchAgent = new SearchAgent(problem, simulatedAnnealingSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)simulatedAnnealingSearch.getOutcome()));
            System.out.println("Final State=\n" + simulatedAnnealingSearch.getLastSearchState());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void eightPuzzleAStarManhattanDemo() {
        System.out.println("\nEightPuzzleDemo AStar Search (ManhattanHeursitic)-->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            AStarSearch aStarSearch = new AStarSearch(new GraphSearch());
            SearchAgent searchAgent = new SearchAgent(problem, aStarSearch);
            EightPuzzleDemo.printActions(searchAgent.getActions());
            EightPuzzleDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printInstrumentation(Properties properties) {
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            System.out.println(string + " : " + string2);
        }
    }

    private static void printActions(List list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            System.out.println(string);
        }
    }
}

