/*
 * Decompiled with CFR 0.152.
 */
package aima.search.csp;

import aima.search.csp.Assignment;
import aima.search.csp.Constraint;
import aima.search.csp.Domain;
import aima.util.Util;
import java.util.ArrayList;
import java.util.List;

public class CSP {
    private Domain domains;
    private Constraint constraints;
    private List<String> variables;

    public CSP(List<String> list, Constraint constraint) {
        this.variables = list;
        this.domains = new Domain(list);
        this.constraints = constraint;
    }

    public CSP(List<String> list, Constraint constraint, Domain domain) {
        this.variables = list;
        this.domains = domain;
        this.constraints = constraint;
    }

    public List defaultOrderDomainOf(String string) {
        return this.domains.getDomainOf(string);
    }

    public Assignment backTrackingSearch() {
        return this.recursiveBackTrackingSearch(new Assignment(this.variables));
    }

    private Assignment recursiveBackTrackingSearch(Assignment assignment) {
        if (assignment.isComplete()) {
            return assignment;
        }
        String string = assignment.selectFirstUnassignedVariable();
        List list = this.defaultOrderDomainOf(string);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!this.constraints.isSatisfiedWith(assignment, string, e)) continue;
            assignment.setAssignment(string, e);
            Assignment assignment2 = this.recursiveBackTrackingSearch(assignment);
            if (assignment2 != null) {
                return assignment2;
            }
            assignment.remove(string);
        }
        return null;
    }

    public Assignment mcSearch(int n) {
        Assignment assignment = this.generateRandomAssignment();
        for (int i = 0; i < n; ++i) {
            if (assignment.satisfies(this.constraints)) {
                return assignment;
            }
            String string = Util.selectRandomlyFromList(assignment.getConflictedVariables(this.constraints));
            Object object = assignment.getMinimumConflictingValueFor(string, this.domains.getDomainOf(string), this.constraints);
            assignment.setAssignment(string, object);
        }
        return null;
    }

    private Assignment generateRandomAssignment() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.variables.size(); ++i) {
            arrayList.add(this.variables.get(i));
        }
        Assignment assignment = new Assignment(arrayList);
        for (int i = 0; i < this.variables.size(); ++i) {
            String string = this.variables.get(i);
            Object object = Util.selectRandomlyFromList(this.domains.getDomainOf(string));
            assignment.setAssignment(string, object);
        }
        return assignment;
    }
}

