/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.util.Matrix;
import aima.util.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransitionModel {
    private Table<String, String, Double> table;
    private List<String> states;

    public TransitionModel(List<String> list, List<String> list2) {
        this.states = list;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (String string2 : list2) {
                arrayList.add(string.concat(string2));
            }
        }
        this.table = new Table(arrayList, list);
    }

    public TransitionModel(List<String> list) {
        this(list, Arrays.asList("do_nothing"));
    }

    public void setTransitionProbability(String string, String string2, Double d) {
        String string3 = string.concat("do_nothing");
        this.table.set(string3, string2, d);
    }

    public void setTransitionProbability(String string, String string2, String string3, Double d) {
        String string4 = string.concat(string2);
        this.table.set(string4, string3, d);
    }

    public double get(String string, String string2) {
        return this.table.get(string, string2);
    }

    public Matrix asMatrix(String string) {
        Matrix matrix = new Matrix(this.states.size(), this.states.size());
        for (int i = 0; i < this.states.size(); ++i) {
            String string2 = this.states.get(i);
            String string3 = string2.concat(string);
            for (int j = 0; j < this.states.size(); ++j) {
                String string4 = this.states.get(j);
                double d = this.get(string3, string4);
                matrix.set(i, j, d);
            }
        }
        return matrix;
    }

    public Matrix asMatrix() {
        return this.asMatrix("do_nothing");
    }

    public Matrix unitMatrix() {
        Matrix matrix = this.asMatrix();
        return Matrix.identity(matrix.getRowDimension(), matrix.getColumnDimension());
    }

    public String getStateForProbability(String string, double d) {
        return this.getStateForGivenActionAndProbability(string, "do_nothing", d);
    }

    public String getStateForProbability(String string, String string2, double d) {
        return this.getStateForGivenActionAndProbability(string, string2, d);
    }

    public String getStateForGivenActionAndProbability(String string, String string2, double d) {
        String string3 = string + string2;
        double d2 = 0.0;
        for (String string4 : this.states) {
            if (!((d2 += this.table.get(string3, string4).doubleValue()) >= d)) continue;
            return string4;
        }
        return null;
    }
}

