/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.decision;

import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPTransition;
import aima.probability.decision.MDPUtilityFunction;
import aima.util.Pair;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MDPTransitionModel<STATE_TYPE, ACTION_TYPE> {
    private Hashtable<MDPTransition<STATE_TYPE, ACTION_TYPE>, Double> transitionToProbability = new Hashtable();
    private List<STATE_TYPE> terminalStates;

    public MDPTransitionModel(List<STATE_TYPE> list) {
        this.terminalStates = list;
    }

    public void setTransitionProbability(STATE_TYPE STATE_TYPE, ACTION_TYPE ACTION_TYPE, STATE_TYPE STATE_TYPE2, double d) {
        if (!this.isTerminal(STATE_TYPE)) {
            MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition = new MDPTransition<STATE_TYPE, ACTION_TYPE>(STATE_TYPE, ACTION_TYPE, STATE_TYPE2);
            this.transitionToProbability.put(mDPTransition, d);
        }
    }

    public double getTransitionProbability(STATE_TYPE STATE_TYPE, ACTION_TYPE ACTION_TYPE, STATE_TYPE STATE_TYPE2) {
        MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition = new MDPTransition<STATE_TYPE, ACTION_TYPE>(STATE_TYPE, ACTION_TYPE, STATE_TYPE2);
        if (this.transitionToProbability.keySet().contains(mDPTransition)) {
            return this.transitionToProbability.get(mDPTransition);
        }
        return 0.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : this.transitionToProbability.keySet()) {
            stringBuffer.append(mDPTransition.toString() + " -> " + this.transitionToProbability.get(mDPTransition) + " \n");
        }
        return stringBuffer.toString();
    }

    public Pair<ACTION_TYPE, Double> getTransitionWithMaximumExpectedUtility(STATE_TYPE STATE_TYPE, MDPUtilityFunction<STATE_TYPE> mDPUtilityFunction) {
        if (this.isTerminal(STATE_TYPE)) {
            return new Pair<Object, Double>(null, 0.0);
        }
        List<MDPTransition<STATE_TYPE, ACTION_TYPE>> list = this.getTransitionsStartingWith(STATE_TYPE);
        Hashtable<ACTION_TYPE, Double> hashtable = this.getExpectedUtilityForSelectedTransitions(list, mDPUtilityFunction);
        return this.getActionWithMaximumUtility(hashtable);
    }

    public Pair<ACTION_TYPE, Double> getTransitionWithMaximumExpectedUtilityUsingPolicy(MDPPolicy<STATE_TYPE, ACTION_TYPE> mDPPolicy, STATE_TYPE STATE_TYPE, MDPUtilityFunction<STATE_TYPE> mDPUtilityFunction) {
        if (this.isTerminal(STATE_TYPE)) {
            return new Pair<Object, Double>(null, 0.0);
        }
        List<MDPTransition<STATE_TYPE, ACTION_TYPE>> list = this.getTransitionsWithStartingStateAndAction(STATE_TYPE, mDPPolicy.getAction(STATE_TYPE));
        Hashtable<ACTION_TYPE, Double> hashtable = this.getExpectedUtilityForSelectedTransitions(list, mDPUtilityFunction);
        return this.getActionWithMaximumUtility(hashtable);
    }

    private boolean isTerminal(STATE_TYPE STATE_TYPE) {
        return this.terminalStates.contains(STATE_TYPE);
    }

    private Pair<ACTION_TYPE, Double> getActionWithMaximumUtility(Hashtable<ACTION_TYPE, Double> hashtable) {
        Pair<Object, Double> pair = new Pair<Object, Double>(null, (Double)Double.MIN_VALUE);
        for (ACTION_TYPE ACTION_TYPE : hashtable.keySet()) {
            Double d = hashtable.get(ACTION_TYPE);
            if (!(d > pair.getSecond())) continue;
            pair = new Pair<ACTION_TYPE, Double>(ACTION_TYPE, d);
        }
        return pair;
    }

    private Hashtable<ACTION_TYPE, Double> getExpectedUtilityForSelectedTransitions(List<MDPTransition<STATE_TYPE, ACTION_TYPE>> list, MDPUtilityFunction<STATE_TYPE> mDPUtilityFunction) {
        Hashtable<ACTION_TYPE, Double> hashtable = new Hashtable<ACTION_TYPE, Double>();
        for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : list) {
            STATE_TYPE STATE_TYPE = mDPTransition.getInitialState();
            ACTION_TYPE ACTION_TYPE = mDPTransition.getAction();
            STATE_TYPE STATE_TYPE2 = mDPTransition.getDestinationState();
            double d = this.getTransitionProbability(STATE_TYPE, ACTION_TYPE, STATE_TYPE2);
            double d2 = d * mDPUtilityFunction.getUtility(STATE_TYPE2);
            Double d3 = (Double)hashtable.get(ACTION_TYPE);
            if (d3 == null) {
                hashtable.put(ACTION_TYPE, d2);
                continue;
            }
            hashtable.put(ACTION_TYPE, d3 + d2);
        }
        return hashtable;
    }

    private List<MDPTransition<STATE_TYPE, ACTION_TYPE>> getTransitionsStartingWith(STATE_TYPE STATE_TYPE) {
        ArrayList<MDPTransition<STATE_TYPE, ACTION_TYPE>> arrayList = new ArrayList<MDPTransition<STATE_TYPE, ACTION_TYPE>>();
        for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : this.transitionToProbability.keySet()) {
            if (!mDPTransition.getInitialState().equals(STATE_TYPE)) continue;
            arrayList.add(mDPTransition);
        }
        return arrayList;
    }

    public List<MDPTransition<STATE_TYPE, ACTION_TYPE>> getTransitionsWithStartingStateAndAction(STATE_TYPE STATE_TYPE, ACTION_TYPE ACTION_TYPE) {
        ArrayList<MDPTransition<STATE_TYPE, ACTION_TYPE>> arrayList = new ArrayList<MDPTransition<STATE_TYPE, ACTION_TYPE>>();
        for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : this.transitionToProbability.keySet()) {
            if (!mDPTransition.getInitialState().equals(STATE_TYPE) || !mDPTransition.getAction().equals(ACTION_TYPE)) continue;
            arrayList.add(mDPTransition);
        }
        return arrayList;
    }

    public ACTION_TYPE randomActionFor(STATE_TYPE STATE_TYPE) {
        List<MDPTransition<STATE_TYPE, ACTION_TYPE>> list = this.getTransitionsStartingWith(STATE_TYPE);
        MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition = Util.selectRandomlyFromList(list);
        return list.get(0).getAction();
    }
}

