/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectedSentence
implements Sentence {
    private String connector;
    private Sentence first;
    private Sentence second;
    private List<Sentence> args = new ArrayList<Sentence>();
    private String stringRep = null;
    private int hashCode = 0;

    public ConnectedSentence(String string, Sentence sentence, Sentence sentence2) {
        this.connector = string;
        this.first = sentence;
        this.second = sentence2;
        this.args.add(sentence);
        this.args.add(sentence2);
    }

    public String getConnector() {
        return this.connector;
    }

    public Sentence getFirst() {
        return this.first;
    }

    public Sentence getSecond() {
        return this.second;
    }

    @Override
    public String getSymbolicName() {
        return this.getConnector();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<Sentence> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor fOLVisitor, Object object) {
        return fOLVisitor.visitConnectedSentence(this, object);
    }

    @Override
    public ConnectedSentence copy() {
        return new ConnectedSentence(this.connector, this.first.copy(), this.second.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectedSentence connectedSentence = (ConnectedSentence)object;
        return connectedSentence.getConnector().equals(this.getConnector()) && connectedSentence.getFirst().equals(this.getFirst()) && connectedSentence.getSecond().equals(this.getSecond());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getConnector().hashCode();
            this.hashCode = 37 * this.hashCode + this.getFirst().hashCode();
            this.hashCode = 37 * this.hashCode + this.getSecond().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.first.toString());
            stringBuilder.append(" ");
            stringBuilder.append(this.connector);
            stringBuilder.append(" ");
            stringBuilder.append(this.second.toString());
            stringBuilder.append(")");
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }
}

