/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing;

import aima.logic.common.Token;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

public class FOLParser {
    private FOLLexer lexer;
    protected Token[] lookAheadBuffer;
    protected int lookAhead = 1;

    public FOLParser(FOLLexer fOLLexer) {
        this.lexer = fOLLexer;
        this.lookAheadBuffer = new Token[this.lookAhead];
    }

    public FOLParser(FOLDomain fOLDomain) {
        this(new FOLLexer(fOLDomain));
    }

    public FOLDomain getFOLDomain() {
        return this.lexer.getFOLDomain();
    }

    public Sentence parse(String string) {
        this.setUpToParse(string);
        return this.parseSentence();
    }

    public void setUpToParse(String string) {
        this.lexer.clear();
        this.lookAheadBuffer = new Token[1];
        this.lexer.setInput(string);
        this.fillLookAheadBuffer();
    }

    private Term parseTerm() {
        Token token = this.lookAhead(1);
        int n = token.getType();
        if (n == 10) {
            return this.parseConstant();
        }
        if (n == 9) {
            return this.parseVariable();
        }
        if (n == 8) {
            return this.parseFunction();
        }
        return null;
    }

    public Term parseVariable() {
        Token token = this.lookAhead(1);
        String string = token.getText();
        this.consume();
        return new Variable(string);
    }

    public Term parseConstant() {
        Token token = this.lookAhead(1);
        String string = token.getText();
        this.consume();
        return new Constant(string);
    }

    public Term parseFunction() {
        Token token = this.lookAhead(1);
        String string = token.getText();
        List<Term> list = this.processTerms();
        return new Function(string, list);
    }

    public Sentence parsePredicate() {
        Token token = this.lookAhead(1);
        String string = token.getText();
        List<Term> list = this.processTerms();
        return new Predicate(string, list);
    }

    private List<Term> processTerms() {
        this.consume();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        this.match("(");
        Term term = this.parseTerm();
        arrayList.add(term);
        while (this.lookAhead(1).getType() == 4) {
            this.match(",");
            term = this.parseTerm();
            arrayList.add(term);
        }
        this.match(")");
        return arrayList;
    }

    public Sentence parseTermEquality() {
        Term term = this.parseTerm();
        this.match("=");
        Term term2 = this.parseTerm();
        return new TermEquality(term, term2);
    }

    public Sentence parseNotSentence() {
        this.match("NOT");
        return new NotSentence(this.parseSentence());
    }

    private Sentence parseSentence() {
        Token token = this.lookAhead(1);
        if (this.lParen(token)) {
            return this.parseParanthizedSentence();
        }
        if (this.lookAhead(1).getType() == 6) {
            return this.parseQuantifiedSentence();
        }
        if (this.notToken(token)) {
            return this.parseNotSentence();
        }
        if (this.predicate(token)) {
            return this.parsePredicate();
        }
        if (this.term(token)) {
            return this.parseTermEquality();
        }
        throw new RuntimeException("parse failed with Token " + token.getText());
    }

    private Sentence parseQuantifiedSentence() {
        String string = this.lookAhead(1).getText();
        this.consume();
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        Variable variable = (Variable)this.parseVariable();
        arrayList.add(variable);
        while (this.lookAhead(1).getType() == 4) {
            this.consume();
            variable = (Variable)this.parseVariable();
            arrayList.add(variable);
        }
        Sentence sentence = this.parseSentence();
        return new QuantifiedSentence(string, arrayList, sentence);
    }

    private Sentence parseParanthizedSentence() {
        this.match("(");
        Sentence sentence = this.parseSentence();
        while (this.binaryConnector(this.lookAhead(1))) {
            String string = this.lookAhead(1).getText();
            this.consume();
            Sentence sentence2 = this.parseSentence();
            sentence = new ConnectedSentence(string, sentence, sentence2);
        }
        this.match(")");
        return sentence;
    }

    private boolean binaryConnector(Token token) {
        return token.getType() == 5 && !token.getText().equals("NOT");
    }

    private boolean lParen(Token token) {
        return token.getType() == 2;
    }

    private boolean term(Token token) {
        return token.getType() == 8 || token.getType() == 10 || token.getType() == 9;
    }

    private boolean predicate(Token token) {
        return token.getType() == 7;
    }

    private boolean notToken(Token token) {
        return token.getType() == 5 && token.getText().equals("NOT");
    }

    protected Token lookAhead(int n) {
        return this.lookAheadBuffer[n - 1];
    }

    protected void consume() {
        this.loadNextTokenFromInput();
    }

    protected void loadNextTokenFromInput() {
        boolean bl = false;
        for (int i = 0; i < this.lookAhead - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            try {
                this.lookAheadBuffer[this.lookAhead - 1] = this.lexer.nextToken();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean isEndOfInput(Token token) {
        return token.getType() == 9999;
    }

    protected void fillLookAheadBuffer() {
        for (int i = 0; i < this.lookAhead; ++i) {
            this.lookAheadBuffer[i] = this.lexer.nextToken();
        }
    }

    protected void match(String string) {
        if (!this.lookAhead(1).getText().equals(string)) {
            throw new RuntimeException("Syntax error detected at match. Expected " + string + " but got " + this.lookAhead(1).getText());
        }
        this.consume();
    }
}

