/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing;

import aima.logic.common.Lexer;
import aima.logic.common.Token;
import aima.logic.fol.domain.FOLDomain;
import java.util.HashSet;
import java.util.Set;

public class FOLLexer
extends Lexer {
    private FOLDomain domain;
    private Set<String> connectors;
    private Set<String> quantifiers;

    public FOLLexer(FOLDomain fOLDomain) {
        this.domain = fOLDomain;
        this.connectors = new HashSet<String>();
        this.connectors.add("NOT");
        this.connectors.add("AND");
        this.connectors.add("OR");
        this.connectors.add("=>");
        this.connectors.add("<=>");
        this.quantifiers = new HashSet<String>();
        this.quantifiers.add("FORALL");
        this.quantifiers.add("EXISTS");
    }

    public FOLDomain getFOLDomain() {
        return this.domain;
    }

    @Override
    public Token nextToken() {
        Object var1_1 = null;
        if (this.lookAhead(1) == '(') {
            this.consume();
            return new Token(2, "(");
        }
        if (this.lookAhead(1) == ')') {
            this.consume();
            return new Token(3, ")");
        }
        if (this.lookAhead(1) == ',') {
            this.consume();
            return new Token(4, ",");
        }
        if (this.identifierDetected()) {
            return this.identifier();
        }
        if (Character.isWhitespace(this.lookAhead(1))) {
            this.consume();
            return this.nextToken();
        }
        if (this.lookAhead(1) == '\uffff') {
            return new Token(9999, "EOI");
        }
        throw new RuntimeException("Lexing error on character " + this.lookAhead(1));
    }

    private Token identifier() {
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isJavaIdentifierPart(this.lookAhead(1)) || this.partOfConnector()) {
            stringBuffer.append(this.lookAhead(1));
            this.consume();
        }
        String string = new String(stringBuffer);
        if (this.connectors.contains(string)) {
            return new Token(5, string);
        }
        if (this.quantifiers.contains(string)) {
            return new Token(6, string);
        }
        if (this.domain.getPredicates().contains(string)) {
            return new Token(7, string);
        }
        if (this.domain.getFunctions().contains(string)) {
            return new Token(8, string);
        }
        if (this.domain.getConstants().contains(string)) {
            return new Token(10, string);
        }
        if (this.isVariable(string)) {
            return new Token(9, string);
        }
        if (string.equals("=")) {
            return new Token(13, string);
        }
        throw new RuntimeException("Lexing error on character " + this.lookAhead(1));
    }

    private boolean isVariable(String string) {
        return Character.isLowerCase(string.charAt(0));
    }

    private boolean identifierDetected() {
        return Character.isJavaIdentifierStart((char)this.lookAheadBuffer[0]) || this.partOfConnector();
    }

    private boolean partOfConnector() {
        return this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>';
    }
}

