/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb;

import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.kb.FOLKnowledgeBase;

public class FOLKnowledgeBaseFactory {
    public static FOLKnowledgeBase createKingsKnowledgeBase(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(DomainFactory.kingsDomain(), inferenceProcedure);
        fOLKnowledgeBase.tell("((King(x) AND Greedy(x)) => Evil(x))");
        fOLKnowledgeBase.tell("King(John)");
        fOLKnowledgeBase.tell("King(Richard)");
        fOLKnowledgeBase.tell("Greedy(John)");
        return fOLKnowledgeBase;
    }

    public static FOLKnowledgeBase createWeaponsKnowledgeBase(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(DomainFactory.weaponsDomain(), inferenceProcedure);
        fOLKnowledgeBase.tell("( (((American(x) AND Weapon(y)) AND Sells(x,y,z)) AND Hostile(z)) => Criminal(x))");
        fOLKnowledgeBase.tell(" Owns(Nono, M1)");
        fOLKnowledgeBase.tell(" Missile(M1)");
        fOLKnowledgeBase.tell("((Missile(x) AND Owns(Nono,x)) => Sells(West,x,Nono))");
        fOLKnowledgeBase.tell("(Missile(x) => Weapon(x))");
        fOLKnowledgeBase.tell("(Enemy(x,America) => Hostile(x))");
        fOLKnowledgeBase.tell("American(West)");
        fOLKnowledgeBase.tell("Enemy(Nono,America)");
        return fOLKnowledgeBase;
    }

    public static FOLKnowledgeBase createLovesAnimalKnowledgeBase(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(DomainFactory.lovesAnimalDomain(), inferenceProcedure);
        fOLKnowledgeBase.tell("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        fOLKnowledgeBase.tell("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        fOLKnowledgeBase.tell("FORALL x (Animal(x) => Loves(Jack, x))");
        fOLKnowledgeBase.tell("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        fOLKnowledgeBase.tell("Cat(Tuna)");
        fOLKnowledgeBase.tell("FORALL x (Cat(x) => Animal(x))");
        return fOLKnowledgeBase;
    }

    public static FOLKnowledgeBase createRingOfThievesKnowledgeBase(InferenceProcedure inferenceProcedure) {
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(DomainFactory.ringOfThievesDomain(), inferenceProcedure);
        fOLKnowledgeBase.tell("(Skis(x) => NOT(Caught(x)))");
        fOLKnowledgeBase.tell("(Caught(x) => NOT(Skis(x)))");
        fOLKnowledgeBase.tell("((Parent(x,y) AND Caught(y)) => Skis(x))");
        fOLKnowledgeBase.tell("(Skis(x) AND Friend(x,y) => Skis(y))");
        fOLKnowledgeBase.tell("(Friend(x,y) => Friend(y,x))");
        fOLKnowledgeBase.tell("Parent(Mike, Joe)");
        fOLKnowledgeBase.tell("Parent(Janet,Joe)");
        fOLKnowledgeBase.tell("Parent(Nancy,Mike)");
        fOLKnowledgeBase.tell("Parent(Ernie,Janet)");
        fOLKnowledgeBase.tell("Parent(Bert,Nancy)");
        fOLKnowledgeBase.tell("Parent(Red,Ernie)");
        fOLKnowledgeBase.tell("Friend(Red,Bert)");
        fOLKnowledgeBase.tell("Friend(Drew,Nancy)");
        fOLKnowledgeBase.tell("Caught(Mike)");
        fOLKnowledgeBase.tell("Caught(Ernie)");
        return fOLKnowledgeBase;
    }

    public static FOLKnowledgeBase createABCEqualityKnowledgeBase(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(fOLDomain, inferenceProcedure);
        fOLKnowledgeBase.tell("B = A");
        fOLKnowledgeBase.tell("B = C");
        if (bl) {
            fOLKnowledgeBase.tell("x = x");
            fOLKnowledgeBase.tell("(x = y => y = x)");
            fOLKnowledgeBase.tell("((x = y AND y = z) => x = z)");
        }
        return fOLKnowledgeBase;
    }

    public static FOLKnowledgeBase createABCDEqualityAndSubstitutionKnowledgeBase(InferenceProcedure inferenceProcedure, boolean bl) {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("F");
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(fOLDomain, inferenceProcedure);
        fOLKnowledgeBase.tell("F(A) = B");
        fOLKnowledgeBase.tell("F(B) = A");
        fOLKnowledgeBase.tell("C = D");
        fOLKnowledgeBase.tell("P(A)");
        fOLKnowledgeBase.tell("P(C)");
        if (bl) {
            fOLKnowledgeBase.tell("x = x");
            fOLKnowledgeBase.tell("(x = y => y = x)");
            fOLKnowledgeBase.tell("((x = y AND y = z) => x = z)");
            fOLKnowledgeBase.tell("((x = y AND F(y) = z) => F(x) = z)");
            fOLKnowledgeBase.tell("((x = y AND P(y)) => P(x))");
        }
        return fOLKnowledgeBase;
    }
}

