/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.AbstractProofStep;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProofStepFoChAssertFact
extends AbstractProofStep {
    private List<ProofStep> predecessors = new ArrayList<ProofStep>();
    private Clause implication = null;
    private Literal fact = null;
    private Map<Variable, Term> bindings = null;

    public ProofStepFoChAssertFact(Clause clause, Literal literal, Map<Variable, Term> map, ProofStep proofStep) {
        this.implication = clause;
        this.fact = literal;
        this.bindings = map;
        if (null != proofStep) {
            this.predecessors.add(proofStep);
        }
    }

    @Override
    public List<ProofStep> getPredecessorSteps() {
        return Collections.unmodifiableList(this.predecessors);
    }

    @Override
    public String getProof() {
        StringBuilder stringBuilder = new StringBuilder();
        List<Literal> list = this.implication.getNegativeLiterals();
        for (int i = 0; i < this.implication.getNumberNegativeLiterals(); ++i) {
            stringBuilder.append(list.get(i).getAtomicSentence());
            if (i == this.implication.getNumberNegativeLiterals() - 1) continue;
            stringBuilder.append(" AND ");
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.implication.getPositiveLiterals().get(0));
        return stringBuilder.toString();
    }

    @Override
    public String getJustification() {
        return "Assert fact " + this.fact.toString() + ", " + this.bindings;
    }
}

