/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.inference.proof.ProofStepGoal;
import aima.logic.fol.inference.proof.ProofStepPremise;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProofFinal
implements Proof {
    private Map<Variable, Term> answerBindings = new LinkedHashMap<Variable, Term>();
    private ProofStep finalStep = null;
    private List<ProofStep> proofSteps = null;

    public ProofFinal(ProofStep proofStep, Map<Variable, Term> map) {
        this.finalStep = proofStep;
        this.answerBindings.putAll(map);
    }

    @Override
    public List<ProofStep> getSteps() {
        if (null == this.proofSteps) {
            this.calcualteProofSteps();
        }
        return this.proofSteps;
    }

    @Override
    public Map<Variable, Term> getAnswerBindings() {
        return this.answerBindings;
    }

    @Override
    public void replaceAnswerBindings(Map<Variable, Term> map) {
        this.answerBindings.clear();
        this.answerBindings.putAll(map);
    }

    public String toString() {
        return this.answerBindings.toString();
    }

    private void calcualteProofSteps() {
        ProofStep proofStep;
        int n;
        this.proofSteps = new ArrayList<ProofStep>();
        this.addToProofSteps(this.finalStep);
        int n2 = 0;
        for (n = 0; n < this.proofSteps.size(); ++n) {
            if (!(this.proofSteps.get(n) instanceof ProofStepPremise)) continue;
            proofStep = this.proofSteps.remove(n);
            this.proofSteps.add(n2, proofStep);
            ++n2;
        }
        for (n = 0; n < this.proofSteps.size(); ++n) {
            if (!(this.proofSteps.get(n) instanceof ProofStepGoal)) continue;
            proofStep = this.proofSteps.remove(n);
            this.proofSteps.add(n2, proofStep);
            ++n2;
        }
        for (n = 0; n < this.proofSteps.size(); ++n) {
            this.proofSteps.get(n).setStepNumber(n + 1);
        }
    }

    private void addToProofSteps(ProofStep proofStep) {
        if (!this.proofSteps.contains(proofStep)) {
            this.proofSteps.add(0, proofStep);
        } else {
            this.proofSteps.remove(proofStep);
            this.proofSteps.add(0, proofStep);
        }
        List<ProofStep> list = proofStep.getPredecessorSteps();
        for (int i = list.size() - 1; i >= 0; --i) {
            this.addToProofSteps(list.get(i));
        }
    }
}

