/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.neural.Layer;
import aima.learning.neural.Vector;
import aima.util.Matrix;
import java.util.ArrayList;

public class LayerSensitivity {
    private Matrix sensitivityMatrix;
    private final Layer layer;

    public LayerSensitivity(Layer layer) {
        Matrix matrix = layer.getWeightMatrix();
        this.sensitivityMatrix = new Matrix(matrix.getRowDimension(), matrix.getColumnDimension());
        this.layer = layer;
    }

    public Matrix getSensitivityMatrix() {
        return this.sensitivityMatrix;
    }

    public Matrix sensitivityMatrixFromErrorMatrix(Vector vector) {
        Matrix matrix = this.createDerivativeMatrix(this.layer.getLastInducedField());
        Matrix matrix2 = matrix.times(vector).times(-2.0);
        this.sensitivityMatrix = matrix2.copy();
        return matrix2;
    }

    public Matrix sensitivityMatrixFromSucceedingLayer(LayerSensitivity layerSensitivity) {
        Layer layer = layerSensitivity.getLayer();
        Matrix matrix = this.createDerivativeMatrix(this.layer.getLastInducedField());
        Matrix matrix2 = layer.getWeightMatrix().transpose();
        Matrix matrix3 = matrix.times(matrix2).times(layerSensitivity.getSensitivityMatrix());
        this.sensitivityMatrix = matrix3.copy();
        return this.sensitivityMatrix;
    }

    private Matrix createDerivativeMatrix(Vector vector) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < vector.size(); ++i) {
            arrayList.add(new Double(this.layer.getActivationFunction().deriv(vector.getValue(i))));
        }
        return Matrix.createDiagonalMatrix(arrayList);
    }

    public Layer getLayer() {
        return this.layer;
    }
}

