/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.util.Table;
import aima.util.Util;
import java.util.Hashtable;
import java.util.List;

public class AdaBoostLearner
implements Learner {
    private List<Learner> learners;
    private DataSet dataSet;
    private double[] exampleWeights;
    private Hashtable<Learner, Double> learnerWeights;

    public AdaBoostLearner(List<Learner> list, DataSet dataSet) {
        this.learners = list;
        this.dataSet = dataSet;
        this.initializeExampleWeights(dataSet.examples.size());
        this.initializeHypothesisWeights(list.size());
    }

    @Override
    public void train(DataSet dataSet) {
        this.initializeExampleWeights(dataSet.examples.size());
        for (Learner learner : this.learners) {
            learner.train(dataSet);
            double d = this.calculateError(dataSet, learner);
            if (d < 1.0E-4) break;
            this.adjustExampleWeights(dataSet, learner, d);
            double d2 = this.learnerWeights.get(learner) * Math.log((1.0 - d) / d);
            this.learnerWeights.put(learner, d2);
        }
    }

    @Override
    public String predict(Example example) {
        return this.weightedMajority(example);
    }

    private String weightedMajority(Example example) {
        List<String> list = this.dataSet.getPossibleAttributeValues(this.dataSet.getTargetAttributeName());
        Table<String, Learner, Double> table = this.createTargetValueLearnerTable(list, example);
        return this.getTargetValueWithTheMaximumVotes(list, table);
    }

    private Table<String, Learner, Double> createTargetValueLearnerTable(List<String> list, Example example) {
        Table<String, Learner, Double> table = new Table<String, Learner, Double>(list, this.learners);
        for (Learner learner : this.learners) {
            for (String object : list) {
                table.set(object, learner, 0.0);
            }
        }
        for (Learner learner : this.learners) {
            String string = learner.predict(example);
            for (String string2 : list) {
                if (!string.equals(string2)) continue;
                table.set(string2, learner, table.get(string2, learner) + this.learnerWeights.get(learner) * 1.0);
            }
        }
        return table;
    }

    private String getTargetValueWithTheMaximumVotes(List<String> list, Table<String, Learner, Double> table) {
        String string = list.get(0);
        double d = this.scoreOfValue(string, table, this.learners);
        for (String string2 : list) {
            double d2 = this.scoreOfValue(string2, table, this.learners);
            if (!(d2 > d)) continue;
            string = string2;
            d = d2;
        }
        return string;
    }

    @Override
    public int[] test(DataSet dataSet) {
        int[] nArray = new int[]{0, 0};
        for (Example example : dataSet.examples) {
            if (example.targetValue().equals(this.predict(example))) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    private void initializeExampleWeights(int n) {
        if (n == 0) {
            throw new RuntimeException("cannot initialize Ensemble learning with Empty Dataset");
        }
        double d = 1.0 / (1.0 * (double)n);
        this.exampleWeights = new double[n];
        for (int i = 0; i < n; ++i) {
            this.exampleWeights[i] = d;
        }
    }

    private void initializeHypothesisWeights(int n) {
        if (n == 0) {
            throw new RuntimeException("cannot initialize Ensemble learning with Zero Learners");
        }
        this.learnerWeights = new Hashtable();
        for (Learner learner : this.learners) {
            this.learnerWeights.put(learner, 1.0);
        }
    }

    private double calculateError(DataSet dataSet, Learner learner) {
        double d = 0.0;
        for (int i = 0; i < dataSet.examples.size(); ++i) {
            Example example = dataSet.getExample(i);
            if (learner.predict(example).equals(example.targetValue())) continue;
            d += this.exampleWeights[i];
        }
        return d;
    }

    private void adjustExampleWeights(DataSet dataSet, Learner learner, double d) {
        double d2 = d / (1.0 - d);
        for (int i = 0; i < dataSet.examples.size(); ++i) {
            Example example = dataSet.getExample(i);
            if (!learner.predict(example).equals(example.targetValue())) continue;
            this.exampleWeights[i] = this.exampleWeights[i] * d2;
        }
        this.exampleWeights = Util.normalize(this.exampleWeights);
    }

    private double scoreOfValue(String string, Table<String, Learner, Double> table, List<Learner> list) {
        double d = 0.0;
        for (Learner learner : list) {
            d += table.get(string, learner).doubleValue();
        }
        return d;
    }
}

