/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.DataSetSpecification;
import aima.learning.framework.Example;
import aima.util.Util;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataSet {
    public List<Example> examples;
    public DataSetSpecification specification;

    protected DataSet() {
    }

    public DataSet(DataSetSpecification dataSetSpecification) {
        this.examples = new LinkedList<Example>();
        this.specification = dataSetSpecification;
    }

    public void add(Example example) {
        this.examples.add(example);
    }

    public int size() {
        return this.examples.size();
    }

    public Example getExample(int n) {
        return this.examples.get(n);
    }

    public DataSet removeExample(Example example) {
        DataSet dataSet = new DataSet(this.specification);
        for (Example example2 : this.examples) {
            if (example.equals(example2)) continue;
            dataSet.add(example2);
        }
        return dataSet;
    }

    public double getInformationFor() {
        Object object;
        String string = this.specification.getTarget();
        Hashtable<double[], Integer> hashtable = new Hashtable<double[], Integer>();
        for (Example example : this.examples) {
            object = example.getAttributeValueAsString(string);
            if (hashtable.containsKey(object)) {
                hashtable.put((double[])object, (Integer)hashtable.get(object) + 1);
                continue;
            }
            hashtable.put((double[])object, 1);
        }
        double d = 0.0;
        object = new double[hashtable.keySet().size()];
        Iterator iterator = hashtable.values().iterator();
        for (int i = 0; i < ((double[])object).length; ++i) {
            object[i] = ((Integer)iterator.next()).intValue();
        }
        object = Util.normalize(object);
        return Util.information(object);
    }

    public Hashtable<String, DataSet> splitByAttribute(String string) {
        Hashtable<String, DataSet> hashtable = new Hashtable<String, DataSet>();
        for (Example example : this.examples) {
            String string2 = example.getAttributeValueAsString(string);
            if (hashtable.containsKey(string2)) {
                hashtable.get(string2).add(example);
                continue;
            }
            DataSet dataSet = new DataSet(this.specification);
            dataSet.add(example);
            hashtable.put(string2, dataSet);
        }
        return hashtable;
    }

    public double calculateGainFor(String string) {
        Hashtable<String, DataSet> hashtable = this.splitByAttribute(string);
        double d = this.examples.size();
        double d2 = 0.0;
        for (String string2 : hashtable.keySet()) {
            double d3 = hashtable.get((Object)string2).examples.size();
            d2 += d3 / d * hashtable.get(string2).getInformationFor();
        }
        return this.getInformationFor() - d2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)object;
        return ((Object)this.examples).equals(dataSet.examples);
    }

    public int hashCode() {
        return 0;
    }

    public Iterator<Example> iterator() {
        return this.examples.iterator();
    }

    public DataSet copy() {
        DataSet dataSet = new DataSet(this.specification);
        for (Example example : this.examples) {
            dataSet.add(example);
        }
        return dataSet;
    }

    public List<String> getAttributeNames() {
        return this.specification.getAttributeNames();
    }

    public String getTargetAttributeName() {
        return this.specification.getTarget();
    }

    public DataSet emptyDataSet() {
        return new DataSet(this.specification);
    }

    public void setSpecification(DataSetSpecification dataSetSpecification) {
        this.specification = dataSetSpecification;
    }

    public List<String> getPossibleAttributeValues(String string) {
        return this.specification.getPossibleAttributeValues(string);
    }

    public DataSet matchingDataSet(String string, String string2) {
        DataSet dataSet = new DataSet(this.specification);
        for (Example example : this.examples) {
            if (!example.getAttributeValueAsString(string).equals(string2)) continue;
            dataSet.add(example);
        }
        return dataSet;
    }

    public List<String> getNonTargetAttributes() {
        return Util.removeFrom(this.getAttributeNames(), this.getTargetAttributeName());
    }
}

