/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.framework;

import aima.gui.framework.AgentAppModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;

public class AgentAppFrame
extends JFrame
implements AgentAppModel.ModelChangedListener {
    protected Controller controller;
    private AgentAppModel model;
    private int updateDelay;
    protected AgentThread agentThread;
    protected boolean isPrepared;
    private SelectorContainer selectors;
    private JToolBar toolbar;
    private JButton clearButton;
    private JButton prepareButton;
    private JButton runButton;
    private JButton cancelButton;
    JSplitPane centerPane;
    protected JTextArea textArea;
    protected AbstractAgentView agentView;
    private JLabel statusLabel;

    public AgentAppFrame() {
        this.initComponents();
        this.pack();
        System.setOut(new PrintStream(new TextAreaOutputStream()));
        this.updateDelay = 0;
        this.setButtonsEnabled(true);
    }

    public void setSelectors(String[] stringArray, String[] stringArray2) {
        Controller controller = this.controller;
        this.controller = null;
        this.selectors.setSelectors(stringArray, stringArray2);
        this.controller = controller;
    }

    public void setSelectorItems(String string, String[] stringArray, int n) {
        Controller controller = this.controller;
        this.controller = null;
        this.selectors.setSelectorItems(string, stringArray, n);
        this.controller = controller;
    }

    public void setDefaultSelection() {
        Controller controller = this.controller;
        this.controller = null;
        this.selectors.setDefaults();
        if (controller != null) {
            this.controller = controller;
            this.selectionChanged();
        }
    }

    public SelectionState getSelection() {
        return this.selectors.getSelection();
    }

    public void setAgentView(AbstractAgentView abstractAgentView) {
        this.agentView = abstractAgentView;
        this.centerPane.add("left", this.agentView);
    }

    public void setSplitPaneResizeWeight(double d) {
        this.centerPane.setResizeWeight(d);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setModel(AgentAppModel agentAppModel) {
        this.model = agentAppModel;
        this.agentView.updateView(agentAppModel);
    }

    public void setUpdateDelay(int n) {
        this.updateDelay = n;
    }

    public void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    @Override
    public void modelChanged() {
        this.agentView.updateView(this.model);
        try {
            Thread.sleep(this.updateDelay);
        }
        catch (Exception exception) {
            this.logMessage("Error: Something went wrong when updating the view after a model change (" + exception + ").");
            exception.printStackTrace();
        }
    }

    @Override
    public void logMessage(String string) {
        MessageLogger messageLogger = new MessageLogger();
        messageLogger.message = string;
        if (SwingUtilities.isEventDispatchThread()) {
            messageLogger.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(messageLogger);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.toolbar = new JToolBar();
        this.selectors = new SelectorContainer();
        this.toolbar.add(Box.createHorizontalGlue());
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Clear Views");
        this.clearButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.clearButton);
        this.prepareButton = new JButton("Prepare");
        this.prepareButton.setToolTipText("Prepare Agent");
        this.prepareButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.prepareButton);
        this.runButton = new JButton("Run");
        this.runButton.setToolTipText("Run Agent");
        this.runButton.addActionListener(new FrameActionListener());
        this.toolbar.add(this.runButton);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.agentView = new AbstractAgentView(){

            @Override
            public void updateView(AgentAppModel agentAppModel) {
            }
        };
        JScrollPane jScrollPane2 = new JScrollPane(this.agentView);
        this.centerPane = new JSplitPane(1);
        this.centerPane.add("left", jScrollPane2);
        this.centerPane.add("right", jScrollPane);
        this.centerPane.setDividerSize(5);
        this.centerPane.setResizeWeight(0.8);
        this.getContentPane().add((Component)this.centerPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("");
        this.statusLabel.setBorder(new EtchedBorder());
        jPanel.add((Component)this.statusLabel, "Center");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel Agent");
        this.cancelButton.addActionListener(new FrameActionListener());
        this.cancelButton.setPreferredSize(new Dimension(80, 20));
        this.cancelButton.setBorder(new EtchedBorder());
        jPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)jPanel, "South");
    }

    private void setButtonsEnabled(boolean bl) {
        this.clearButton.setEnabled(bl);
        this.prepareButton.setEnabled(bl);
        this.runButton.setEnabled(bl);
        this.cancelButton.setEnabled(!bl);
        for (JComboBox jComboBox : this.selectors.combos) {
            jComboBox.setEnabled(bl);
        }
    }

    protected void selectionChanged() {
        if (this.controller != null) {
            this.controller.prepareAgent();
            this.isPrepared = true;
        }
    }

    public static void main(String[] stringArray) {
        AgentAppFrame agentAppFrame = new AgentAppFrame();
        agentAppFrame.setVisible(true);
    }

    public static interface Controller {
        public void clearAgent();

        public void prepareAgent();

        public void runAgent();
    }

    public static abstract class AbstractAgentView
    extends JPanel {
        public abstract void updateView(AgentAppModel var1);
    }

    public static class SelectionState {
        private final List<String> selectors = new ArrayList<String>();
        private final List<Integer> selIndices = new ArrayList<Integer>();

        protected SelectionState(String[] stringArray) {
            for (String string : stringArray) {
                this.selectors.add(string);
                this.selIndices.add(null);
            }
        }

        public int size() {
            return this.selectors.size();
        }

        void setValue(int n, int n2) {
            this.selIndices.set(n, n2);
        }

        void setValue(String string, int n) {
            this.selIndices.set(this.selectors.indexOf(string), n);
        }

        public int getValue(int n) {
            return this.selIndices.get(n);
        }

        public int getValue(String string) {
            return this.selIndices.get(this.selectors.indexOf(string));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("State[ ");
            for (int i = 0; i < this.size(); ++i) {
                stringBuffer.append(this.selectors.get(i) + "=" + this.selIndices.get(i) + " ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class SelectorContainer {
        String[] selectorNames = new String[0];
        int[] selectorDefaults = new int[0];
        List<JComboBox> combos = new ArrayList<JComboBox>();

        private SelectorContainer() {
        }

        public void setSelectors(String[] stringArray, String[] stringArray2) {
            this.selectorNames = stringArray;
            this.selectorDefaults = new int[stringArray.length];
            for (JComboBox jComboBox : this.combos) {
                AgentAppFrame.this.toolbar.remove(jComboBox);
            }
            this.combos.clear();
            for (int i = 0; i < stringArray.length; ++i) {
                JComboBox jComboBox = new JComboBox();
                jComboBox.addActionListener(new FrameActionListener());
                this.combos.add(jComboBox);
                AgentAppFrame.this.toolbar.add((Component)jComboBox, i);
                if (stringArray2 == null) continue;
                jComboBox.setToolTipText(stringArray2[i]);
            }
        }

        public void setSelectorItems(String string, String[] stringArray, int n) {
            JComboBox jComboBox = this.getCombo(string);
            jComboBox.removeAllItems();
            for (String string2 : stringArray) {
                jComboBox.addItem(string2);
            }
            this.selectorDefaults[this.combos.indexOf((Object)jComboBox)] = n;
        }

        public void setDefaults() {
            for (int i = 0; i < this.selectorDefaults.length; ++i) {
                if (this.combos.get(i).getItemCount() <= 0) continue;
                this.combos.get(i).setSelectedIndex(this.selectorDefaults[i]);
            }
        }

        public SelectionState getSelection() {
            SelectionState selectionState = new SelectionState(this.selectorNames);
            for (int i = 0; i < selectionState.size(); ++i) {
                selectionState.setValue(i, this.combos.get(i).getSelectedIndex());
            }
            return selectionState;
        }

        JComboBox getCombo(String string) {
            for (int i = 0; i < this.selectorNames.length; ++i) {
                if (!this.selectorNames[i].equals(string)) continue;
                return this.combos.get(i);
            }
            return null;
        }
    }

    private class TextAreaOutputStream
    extends OutputStream {
        private TextAreaOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            String string = new String(new char[]{(char)n});
            AgentAppFrame.this.textArea.append(string);
        }
    }

    private class AgentThread
    extends Thread {
        private AgentThread() {
        }

        @Override
        public void run() {
            AgentAppFrame.this.agentThread = this;
            try {
                AgentAppFrame.this.controller.runAgent();
            }
            catch (Exception exception) {
                AgentAppFrame.this.logMessage("Error: Somthing went wrong running the agent (" + exception + ").");
                exception.printStackTrace();
            }
            AgentAppFrame.this.setButtonsEnabled(true);
            AgentAppFrame.this.agentThread = null;
        }
    }

    private class FrameActionListener
    implements ActionListener {
        private FrameActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            try {
                if (AgentAppFrame.this.controller != null) {
                    AgentAppFrame.this.setStatus("");
                    Object object = actionEvent.getSource();
                    if (object == AgentAppFrame.this.clearButton) {
                        string = "when clearing the views ";
                        Document document = AgentAppFrame.this.textArea.getDocument();
                        document.remove(0, document.getLength());
                        AgentAppFrame.this.statusLabel.setText("");
                        AgentAppFrame.this.controller.clearAgent();
                    } else if (object == AgentAppFrame.this.prepareButton) {
                        string = "when preparing the agent ";
                        AgentAppFrame.this.controller.prepareAgent();
                        AgentAppFrame.this.isPrepared = true;
                    } else if (object == AgentAppFrame.this.runButton) {
                        string = "when preparing the agent ";
                        if (!AgentAppFrame.this.isPrepared) {
                            AgentAppFrame.this.controller.prepareAgent();
                        }
                        string = "when running the agent ";
                        AgentAppFrame.this.setButtonsEnabled(false);
                        AgentAppFrame.this.agentThread = new AgentThread();
                        AgentAppFrame.this.agentThread.start();
                        AgentAppFrame.this.isPrepared = false;
                    } else if (object == AgentAppFrame.this.cancelButton) {
                        string = "when cancelling the agent ";
                        if (AgentAppFrame.this.agentThread != null) {
                            AgentAppFrame.this.agentThread.stop();
                            AgentAppFrame.this.agentThread = null;
                            AgentAppFrame.this.setStatus("Task cancelled.");
                            AgentAppFrame.this.setButtonsEnabled(true);
                        }
                        AgentAppFrame.this.isPrepared = false;
                    } else if (((AgentAppFrame)AgentAppFrame.this).selectors.combos.contains(object)) {
                        string = "when preparing the agent ";
                        AgentAppFrame.this.selectionChanged();
                    }
                }
            }
            catch (Exception exception) {
                AgentAppFrame.this.logMessage("Error: Something went wrong " + string + "(" + exception + ").");
                exception.printStackTrace();
            }
        }
    }

    private class MessageLogger
    implements Runnable {
        String message;

        private MessageLogger() {
        }

        @Override
        public void run() {
            int n = AgentAppFrame.this.textArea.getDocument().getLength();
            AgentAppFrame.this.textArea.append(this.message + "\n");
            int n2 = AgentAppFrame.this.textArea.getDocument().getLength();
            AgentAppFrame.this.textArea.setSelectionStart(n);
            AgentAppFrame.this.textArea.setSelectionEnd(n2);
        }
    }
}

