/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications;

import aima.basic.Agent;
import aima.basic.vaccum.ModelBasedTVEVaccumAgent;
import aima.basic.vaccum.ReflexVaccumAgent;
import aima.basic.vaccum.ReflexVaccumAgentWithState;
import aima.basic.vaccum.SimpleReflexVaccumAgent;
import aima.basic.vaccum.TableDrivenVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentAppModel;
import aima.gui.framework.AgentView;
import aima.gui.framework.SimpleAgentAppDemo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;

public class VacuumAppDemo
extends SimpleAgentAppDemo {
    @Override
    public AgentAppModel createModel() {
        return new VacuumModel();
    }

    @Override
    public AgentAppFrame createFrame() {
        return new VacuumFrame();
    }

    @Override
    public AgentAppController createController() {
        return new VacuumController();
    }

    public static void main(String[] stringArray) {
        new VacuumAppDemo().startApplication();
    }

    protected static class VacuumController
    extends AgentAppController {
        protected VacuumController() {
        }

        @Override
        public void clearAgent() {
        }

        @Override
        public void prepareAgent() {
            AgentAppFrame.SelectionState selectionState = this.frame.getSelection();
            TrivialVaccumEnvironment trivialVaccumEnvironment = null;
            Agent agent = null;
            switch (selectionState.getValue(VacuumFrame.ENV_SEL)) {
                case 0: {
                    trivialVaccumEnvironment = new TrivialVaccumEnvironment();
                }
            }
            switch (selectionState.getValue(VacuumFrame.AGENT_SEL)) {
                case 0: {
                    agent = new SimpleReflexVaccumAgent();
                    break;
                }
                case 1: {
                    agent = new ReflexVaccumAgent();
                    break;
                }
                case 2: {
                    agent = new ReflexVaccumAgentWithState();
                    break;
                }
                case 3: {
                    agent = new TableDrivenVaccumAgent();
                    break;
                }
                case 4: {
                    agent = new ModelBasedTVEVaccumAgent();
                }
            }
            ((VacuumModel)this.model).setEnv(trivialVaccumEnvironment);
            ((VacuumModel)this.model).setAgent(agent);
            if (trivialVaccumEnvironment != null && agent != null) {
                trivialVaccumEnvironment.addAgent(agent);
                trivialVaccumEnvironment.registerView(this.model);
                this.frame.modelChanged();
            }
        }

        @Override
        public void runAgent() {
            VacuumModel vacuumModel = (VacuumModel)this.model;
            this.frame.logMessage("<simulation-log>");
            vacuumModel.getEnv().stepUntilDone();
            this.frame.logMessage("Performance: " + vacuumModel.getEnv().getAgentperformance(vacuumModel.getAgent()));
            this.frame.logMessage("</simulation-log>");
            this.frame.setStatus("Task completed.");
        }
    }

    protected static class VacuumView
    extends AgentView {
        Hashtable<String, int[]> dirtLookup = new Hashtable();

        protected VacuumView() {
        }

        int[] getDirt(String string) {
            int[] nArray = this.dirtLookup.get(string);
            if (nArray == null) {
                Random random = new Random();
                int n = random.nextInt(8) + 4;
                nArray = new int[2 * n];
                for (int i = 0; i < n; ++i) {
                    nArray[2 * i] = random.nextInt(6) + 1;
                    nArray[2 * i + 1] = random.nextInt(8) + 1;
                }
            }
            this.dirtLookup.put(string, nArray);
            return nArray;
        }

        @Override
        public void paint(Graphics graphics) {
            VacuumModel vacuumModel = (VacuumModel)this.model;
            List<String> list = vacuumModel.getLocations();
            this.adjustTransformation(0.0, 0.0, 11 * list.size() - 1, 10.0);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(this.x(11 * i), this.y(0.0), this.scale(10), this.scale(10));
                if (vacuumModel.isDirty(string)) {
                    int[] nArray = this.getDirt(string);
                    for (int j = 0; j < nArray.length; j += 2) {
                        graphics2D.setColor(Color.lightGray);
                        graphics2D.fillOval(this.x(11 * i + nArray[j]), this.y(nArray[j + 1]), this.scale(3), this.scale(2));
                    }
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, this.x(11 * i) + 10, this.y(0.0) + 20);
                if (!vacuumModel.hasAgent(string)) continue;
                graphics2D.setColor(Color.red);
                graphics2D.fillOval(this.x(11 * i + 2), this.y(2.0), this.scale(6), this.scale(6));
            }
        }
    }

    protected static class VacuumFrame
    extends AgentAppFrame {
        public static String ENV_SEL = "EnvSelection";
        public static String AGENT_SEL = "AgentSelection";

        public VacuumFrame() {
            this.setAgentView(new VacuumView());
            this.setSelectors(new String[]{ENV_SEL, AGENT_SEL}, new String[]{"Select Environment", "Select Agent"});
            this.setSelectorItems(ENV_SEL, new String[]{"A/B Environment"}, 0);
            this.setSelectorItems(AGENT_SEL, new String[]{"SimpleReflexVaccumAgent", "ReflexVaccumAgent", "ReflexVaccumAgentWithState", "TableDrivenVaccumAgent", "ModelBasedTVEVaccumAgent"}, 0);
            this.setTitle("Vacuum Agent Application");
            this.setSize(800, 400);
            this.setUpdateDelay(500);
        }
    }

    protected static class VacuumModel
    extends AgentAppModel {
        private TrivialVaccumEnvironment env;
        private Agent agent;
        public static String DIRTY = "Dirty";

        protected VacuumModel() {
        }

        public void setEnv(TrivialVaccumEnvironment trivialVaccumEnvironment) {
            this.env = trivialVaccumEnvironment;
        }

        public TrivialVaccumEnvironment getEnv() {
            return this.env;
        }

        public void setAgent(Agent agent) {
            this.agent = agent;
        }

        public Agent getAgent() {
            return this.agent;
        }

        public List<String> getLocations() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.env != null) {
                arrayList.add("A");
                arrayList.add("B");
            }
            return arrayList;
        }

        public boolean isDirty(String string) {
            return DIRTY.equals(this.env.getLocationStatus(string));
        }

        public boolean hasAgent(String string) {
            return this.agent != null && string.equals(this.env.getAgentLocation(this.agent));
        }
    }
}

